/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry.collect;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.terracotta.context.ContextManager;
import org.terracotta.context.TreeNode;
import org.terracotta.context.extended.OperationStatisticDescriptor;
import org.terracotta.context.extended.ValueStatisticDescriptor;
import org.terracotta.context.query.Matcher;
import org.terracotta.context.query.Matchers;
import org.terracotta.context.query.QueryBuilder;
import org.terracotta.management.model.Objects;
import org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.extended.StatisticType;

public class StatisticRegistry {
    private static final Object ME = new Object();
    private final Object contextObject;
    private final Map<String, ValueStatistic<? extends Number>> statistics = new HashMap<String, ValueStatistic<? extends Number>>();
    private final Map<String, StatisticType> statisticTypes = new HashMap<String, StatisticType>();

    public StatisticRegistry(Object contextObject) {
        this.contextObject = Objects.requireNonNull(contextObject);
    }

    public Collection<StatisticDescriptor> getDescriptors() {
        HashSet<StatisticDescriptor> descriptors = new HashSet<StatisticDescriptor>(this.statistics.size());
        for (Map.Entry<String, ValueStatistic<? extends Number>> entry : this.statistics.entrySet()) {
            String fullStatName = entry.getKey();
            StatisticType type = this.statisticTypes.get(fullStatName);
            descriptors.add(new StatisticDescriptor(fullStatName, type.name()));
        }
        return descriptors;
    }

    public Number queryStatistic(String fullStatisticName) {
        ValueStatistic<? extends Number> statistic = this.statistics.get(fullStatisticName);
        return statistic == null ? (Number)null : (Number)statistic.value();
    }

    public Map<String, Number> queryStatistics() {
        HashMap<String, Number> stats = new HashMap<String, Number>(this.statistics.size());
        for (String fullStatName : this.statistics.keySet()) {
            Number statistic = this.queryStatistic(fullStatName);
            if (statistic == null) continue;
            stats.put(fullStatName, statistic);
        }
        return stats;
    }

    public <N extends Number> void registerSize(String fullStatName, ValueStatistic<N> accessor) {
        this.registerStatistic(fullStatName, StatisticType.SIZE, accessor);
    }

    public void registerSize(String statNameSuffix, ValueStatisticDescriptor descriptor) {
        this.registerStatistic(statNameSuffix, StatisticType.SIZE, descriptor);
    }

    public <T extends Enum<T>> void registerSize(String statNameSuffix, OperationStatisticDescriptor<T> descriptor, EnumSet<T> outcomes) {
        this.registerStatistic(statNameSuffix, StatisticType.SIZE, descriptor, outcomes);
    }

    public <N extends Number> void registerCounter(String fullStatName, ValueStatistic<N> accessor) {
        this.registerStatistic(fullStatName, StatisticType.COUNTER, accessor);
    }

    public void registerCounter(String statNameSuffix, ValueStatisticDescriptor descriptor) {
        this.registerStatistic(statNameSuffix, StatisticType.COUNTER, descriptor);
    }

    public <T extends Enum<T>> void registerCounter(String statNameSuffix, OperationStatisticDescriptor<T> descriptor, EnumSet<T> outcomes) {
        this.registerStatistic(statNameSuffix, StatisticType.COUNTER, descriptor, outcomes);
    }

    private <N extends Number> void registerStatistic(String statNameSuffix, StatisticType type, ValueStatisticDescriptor descriptor) {
        TreeNode treeNode = ContextManager.nodeFor(this.contextObject);
        if (treeNode == null) {
            return;
        }
        Set<TreeNode> result = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("name", descriptor.getObserverName()), this.hasTags(descriptor.getTags()))))).filter(Matchers.context(Matchers.identifier(Matchers.subclassOf(ValueStatistic.class)))).build().execute(Collections.singleton(treeNode));
        if (!result.isEmpty()) {
            for (TreeNode node : result) {
                String discriminator = null;
                Map properties = (Map)node.getContext().attributes().get("properties");
                if (properties != null && properties.containsKey("discriminator")) {
                    discriminator = properties.get("discriminator").toString();
                }
                String fullStatName = (discriminator == null ? "" : discriminator + ":") + statNameSuffix;
                ValueStatistic statistic = (ValueStatistic)node.getContext().attributes().get("this");
                this.registerStatistic(fullStatName, type, statistic);
            }
        }
    }

    private <T extends Enum<T>> void registerStatistic(String statNameSuffix, StatisticType type, OperationStatisticDescriptor<T> descriptor, final EnumSet<T> outcomes) {
        TreeNode treeNode = ContextManager.nodeFor(this.contextObject);
        if (treeNode == null) {
            return;
        }
        Set<TreeNode> result = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("type", descriptor.getType()), Matchers.hasAttribute("name", descriptor.getObserverName()), this.hasTags(descriptor.getTags()))))).filter(Matchers.context(Matchers.identifier(Matchers.subclassOf(OperationStatistic.class)))).build().execute(Collections.singleton(treeNode));
        if (!result.isEmpty()) {
            for (TreeNode node : result) {
                String discriminator = null;
                Map properties = (Map)node.getContext().attributes().get("properties");
                if (properties != null && properties.containsKey("discriminator")) {
                    discriminator = properties.get("discriminator").toString();
                }
                String fullStatName = (discriminator == null ? "" : discriminator + ":") + statNameSuffix;
                final OperationStatistic statistic = (OperationStatistic)node.getContext().attributes().get("this");
                this.registerStatistic(fullStatName, type, new ValueStatistic<Number>(){

                    @Override
                    public Number value() {
                        return statistic.sum(outcomes);
                    }
                });
            }
        }
    }

    private Matcher<Map<String, Object>> hasTags(final Collection<String> tags) {
        return Matchers.hasAttribute("tags", (Matcher<? extends Object>)new Matcher<Collection<String>>(){

            @Override
            protected boolean matchesSafely(Collection<String> object) {
                return object.containsAll(tags);
            }
        });
    }

    private <N extends Number> void registerStatistic(String fullStatName, StatisticType type, ValueStatistic<N> accessor) {
        if (this.statistics.put(fullStatName, accessor) != null) {
            throw new IllegalArgumentException("Found duplicate statistic " + fullStatName);
        }
        this.statisticTypes.put(fullStatName, type);
    }

    public static final StatisticRegistry noop() {
        return new StatisticRegistry(ME);
    }
}

