/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.service.monitoring.registry.provider;

import com.tc.classloader.CommonComponent;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.AbstractManagementProvider;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.registry.action.ExposedObject;
import org.terracotta.management.service.monitoring.EntityMonitoringService;
import org.terracotta.management.service.monitoring.registry.provider.MonitoringServiceAware;

@CommonComponent
public abstract class AbstractConsumerManagementProvider<T>
extends AbstractManagementProvider<T>
implements ManagementProvider<T>,
MonitoringServiceAware {
    private EntityMonitoringService monitoringService;

    public AbstractConsumerManagementProvider(Class<? extends T> managedType) {
        super(managedType);
    }

    @Override
    public void setMonitoringService(EntityMonitoringService monitoringService) {
        this.monitoringService = Objects.requireNonNull(monitoringService);
    }

    protected EntityMonitoringService getMonitoringService() {
        return Objects.requireNonNull(this.monitoringService);
    }

    public void register(T managedObject) {
        try {
            this.registerAsync(managedObject).toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public CompletableFuture<Void> registerAsync(T managedObject) {
        super.register(managedObject);
        return CompletableFuture.completedFuture(null);
    }

    protected ExposedObject<T> wrap(T managedObject) {
        Context context = Context.create((String)"consumerId", (String)String.valueOf(this.getMonitoringService().getConsumerId()));
        return this.internalWrap(context, managedObject);
    }

    protected abstract ExposedObject<T> internalWrap(Context var1, T var2);
}

