/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.service.monitoring.registry.provider;

import com.tc.classloader.CommonComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.Named;
import org.terracotta.management.registry.RequiredContext;
import org.terracotta.management.registry.action.ExposedObject;
import org.terracotta.management.registry.collect.StatisticRegistry;
import org.terracotta.management.service.monitoring.registry.provider.AbstractExposedStatistics;
import org.terracotta.management.service.monitoring.registry.provider.AliasBinding;
import org.terracotta.management.service.monitoring.registry.provider.AliasBindingManagementProvider;

@RequiredContext(value={@Named(value="consumerId")})
@CommonComponent
public abstract class AbstractStatisticsManagementProvider<T extends AliasBinding>
extends AliasBindingManagementProvider<T> {
    public AbstractStatisticsManagementProvider(Class<? extends T> type) {
        super(type);
    }

    protected void dispose(ExposedObject<T> exposedObject) {
        ((AbstractExposedStatistics)exposedObject).close();
    }

    public final Collection<? extends Descriptor> getDescriptors() {
        ArrayList list = new ArrayList(super.getDescriptors());
        Collections.sort(list, STATISTIC_DESCRIPTOR_COMPARATOR);
        return list;
    }

    public Map<String, Number> collectStatistics(Context context, Collection<String> statisticNames) {
        TreeMap<String, Number> statistics = new TreeMap<String, Number>();
        AbstractExposedStatistics exposedObject = (AbstractExposedStatistics)this.findExposedObject(context);
        if (exposedObject != null) {
            if (statisticNames == null || statisticNames.isEmpty()) {
                statistics.putAll(exposedObject.queryStatistics());
            } else {
                for (String statisticName : statisticNames) {
                    Number statistic = exposedObject.queryStatistic(statisticName);
                    if (statistic == null) continue;
                    statistics.put(statisticName, statistic);
                }
            }
        }
        return statistics;
    }

    @Override
    protected AbstractExposedStatistics<T> wrap(T managedObject) {
        Context context = Context.empty().with("consumerId", String.valueOf(this.getMonitoringService().getConsumerId())).with("alias", ((AliasBinding)managedObject).getAlias());
        StatisticRegistry statisticRegistry = this.getStatisticRegistry(managedObject);
        return this.internalWrap(context, managedObject, statisticRegistry);
    }

    protected StatisticRegistry getStatisticRegistry(T managedObject) {
        return new StatisticRegistry(((AliasBinding)managedObject).getValue());
    }

    @Override
    protected final AbstractExposedStatistics<T> internalWrap(Context context, T managedObject) {
        throw new UnsupportedOperationException();
    }

    protected abstract AbstractExposedStatistics<T> internalWrap(Context var1, T var2, StatisticRegistry var3);
}

