/**
 * Copyright (C) 2011-2012 Typesafe Inc. <http://typesafe.com>
 */
package org.ekrich.config.impl

import util.control.Breaks._
import org.ekrich.config.ConfigException

import scala.collection.mutable

final class PathBuilder private[impl] () {
  final private val keys = new mutable.Stack[String]
  // the keys are kept "backward" (top of stack is end of path)
  private var resultPath: Path = null

  private def checkCanAppend(): Unit = {
    if (resultPath != null)
      throw new ConfigException.BugOrBroken(
        "Adding to PathBuilder after getting result"
      )
  }

  private[impl] def appendKey(key: String): Unit = {
    checkCanAppend()
    keys.push(key)
  }

  private[impl] def appendPath(path: Path): Unit = {
    checkCanAppend()
    var first = path.first
    var remainder = path.remainder
    breakable {
      while (true) {
        keys.push(first)
        if (remainder != null) {
          first = remainder.first
          remainder = remainder.remainder
        } else break() // break
      }
    }
  }

  private[impl] def result: Path = {
    // note: if keys is empty, we want to return null, which is a valid empty path
    if (resultPath == null) {
      var remainder: Path = null
      while (!keys.isEmpty) {
        val key = keys.pop()
        remainder = new Path(key, remainder)
      }
      resultPath = remainder
    }
    resultPath
  }
}
