/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.android.http;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.ektorp.android.http.AndroidHttpResponse;
import org.ektorp.android.http.AndroidSSLSocketFactory;
import org.ektorp.http.HttpClient;
import org.ektorp.http.HttpCopyRequest;
import org.ektorp.http.IdleConnectionMonitor;
import org.ektorp.http.PreemptiveAuthRequestInterceptor;
import org.ektorp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidHttpClient
implements HttpClient {
    private final org.apache.http.client.HttpClient client;
    private final org.apache.http.client.HttpClient backend;
    private static final Logger LOG = LoggerFactory.getLogger(AndroidHttpClient.class);

    public AndroidHttpClient(org.apache.http.client.HttpClient hc) {
        this(hc, hc);
    }

    public AndroidHttpClient(org.apache.http.client.HttpClient hc, org.apache.http.client.HttpClient backend) {
        this.client = hc;
        this.backend = backend;
    }

    public org.ektorp.http.HttpResponse delete(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpDelete(uri));
    }

    public org.ektorp.http.HttpResponse get(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpGet(uri));
    }

    public org.ektorp.http.HttpResponse get(String uri, Map<String, String> headers) {
        return this.executeRequest((HttpRequestBase)new HttpGet(uri), headers);
    }

    public org.ektorp.http.HttpResponse getUncached(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpGet(uri), true);
    }

    public org.ektorp.http.HttpResponse head(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpHead(uri));
    }

    public org.ektorp.http.HttpResponse post(String uri, String content) {
        return this.executePutPost((HttpEntityEnclosingRequestBase)new HttpPost(uri), content, false);
    }

    public org.ektorp.http.HttpResponse post(String uri, InputStream content) {
        InputStreamEntity e = new InputStreamEntity(content, -1L);
        e.setContentType("application/json");
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)e);
        return this.executeRequest((HttpRequestBase)post);
    }

    public org.ektorp.http.HttpResponse postUncached(String uri, String content) {
        return this.executePutPost((HttpEntityEnclosingRequestBase)new HttpPost(uri), content, true);
    }

    public org.ektorp.http.HttpResponse put(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpPut(uri));
    }

    public org.ektorp.http.HttpResponse put(String uri, String content) {
        return this.executePutPost((HttpEntityEnclosingRequestBase)new HttpPut(uri), content, false);
    }

    public org.ektorp.http.HttpResponse put(String uri, InputStream data, String contentType, long contentLength) {
        InputStreamEntity e = new InputStreamEntity(data, contentLength);
        e.setContentType(contentType);
        HttpPut hp = new HttpPut(uri);
        hp.setEntity((HttpEntity)e);
        return this.executeRequest((HttpRequestBase)hp);
    }

    public org.ektorp.http.HttpResponse copy(String sourceUri, String destination) {
        return this.executeRequest((HttpRequestBase)new HttpCopyRequest(sourceUri, destination), true);
    }

    private org.ektorp.http.HttpResponse executePutPost(HttpEntityEnclosingRequestBase request, String content, boolean useBackend) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Content: {}", (Object)content);
            }
            StringEntity e = new StringEntity(content, "UTF-8");
            e.setContentType("application/json");
            request.setEntity((HttpEntity)e);
            return this.executeRequest((HttpRequestBase)request, useBackend);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private org.ektorp.http.HttpResponse executeRequest(HttpRequestBase request, Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request.setHeader(header.getKey(), header.getValue());
        }
        return this.executeRequest(request);
    }

    private org.ektorp.http.HttpResponse executeRequest(HttpRequestBase request, boolean useBackend) {
        try {
            HttpResponse rsp = useBackend ? this.backend.execute((HttpUriRequest)request) : this.client.execute((HttpHost)this.client.getParams().getParameter("http.default-host"), (HttpRequest)request);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("%s %s %s %s", request.getMethod(), request.getURI(), rsp.getStatusLine().getStatusCode(), rsp.getStatusLine().getReasonPhrase()));
            }
            return AndroidHttpResponse.of(rsp, request);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private org.ektorp.http.HttpResponse executeRequest(HttpRequestBase request) {
        return this.executeRequest(request, false);
    }

    public void shutdown() {
        this.client.getConnectionManager().shutdown();
    }

    public static class Builder {
        String host = "localhost";
        int port = 5984;
        int maxConnections = 20;
        int connectionTimeout = 1000;
        int socketTimeout = 10000;
        ClientConnectionManager conman;
        int proxyPort = -1;
        String proxy = null;
        boolean enableSSL = false;
        boolean relaxedSSLSettings = false;
        SSLSocketFactory sslSocketFactory;
        String username;
        String password;
        boolean cleanupIdleConnections = true;
        boolean useExpectContinue = true;
        boolean caching = true;
        int maxObjectSizeBytes = 8192;
        int maxCacheEntries = 1000;

        public Builder url(String s) throws MalformedURLException {
            if (s == null) {
                return this;
            }
            return this.url(new URL(s));
        }

        public Builder url(URL url) {
            this.host = url.getHost();
            this.port = url.getPort();
            this.enableSSL("https".equals(url.getProtocol()));
            return this;
        }

        public Builder host(String s) {
            this.host = s;
            return this;
        }

        public Builder proxyPort(int p) {
            this.proxyPort = p;
            return this;
        }

        public Builder proxy(String s) {
            this.proxy = s;
            return this;
        }

        public Builder caching(boolean b) {
            this.caching = b;
            return this;
        }

        public Builder maxCacheEntries(int m) {
            this.maxCacheEntries = m;
            return this;
        }

        public Builder maxObjectSizeBytes(int m) {
            this.maxObjectSizeBytes = m;
            return this;
        }

        public ClientConnectionManager configureConnectionManager(HttpParams params) {
            if (this.conman == null) {
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(this.configureScheme());
                ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(params, schemeRegistry);
                this.conman = cm;
            }
            if (this.cleanupIdleConnections) {
                IdleConnectionMonitor.monitor((ClientConnectionManager)this.conman);
            }
            return this.conman;
        }

        private Scheme configureScheme() {
            if (this.enableSSL) {
                try {
                    AndroidSSLSocketFactory androidSSLSocketFactory = new AndroidSSLSocketFactory((KeyStore)null);
                    androidSSLSocketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                    return new Scheme("https", (SocketFactory)androidSSLSocketFactory, this.port);
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            return new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), this.port);
        }

        public org.apache.http.client.HttpClient configureClient() {
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)this.useExpectContinue);
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.connectionTimeout);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.socketTimeout);
            HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)Boolean.TRUE);
            String protocol = "http";
            if (this.enableSSL) {
                protocol = "https";
            }
            params.setParameter("http.default-host", (Object)new HttpHost(this.host, this.port, protocol));
            if (this.proxy != null) {
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(this.proxy, this.proxyPort, protocol));
            }
            DefaultHttpClient client = new DefaultHttpClient(this.configureConnectionManager((HttpParams)params), (HttpParams)params);
            if (this.username != null && this.password != null) {
                client.getCredentialsProvider().setCredentials(new AuthScope(this.host, this.port, AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                client.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthRequestInterceptor(), 0);
            }
            return client;
        }

        public Builder port(int i) {
            this.port = i;
            return this;
        }

        public Builder username(String s) {
            this.username = s;
            return this;
        }

        public Builder password(String s) {
            this.password = s;
            return this;
        }

        public Builder maxConnections(int i) {
            this.maxConnections = i;
            return this;
        }

        public Builder connectionTimeout(int i) {
            this.connectionTimeout = i;
            return this;
        }

        public Builder socketTimeout(int i) {
            this.socketTimeout = i;
            return this;
        }

        public Builder cleanupIdleConnections(boolean b) {
            this.cleanupIdleConnections = b;
            return this;
        }

        public Builder connectionManager(ClientConnectionManager cm) {
            this.conman = cm;
            return this;
        }

        public Builder enableSSL(boolean b) {
            this.enableSSL = b;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory f) {
            this.sslSocketFactory = f;
            return this;
        }

        public Builder relaxedSSLSettings(boolean b) {
            this.relaxedSSLSettings = b;
            return this;
        }

        public Builder useExpectContinue(boolean b) {
            this.useExpectContinue = b;
            return this;
        }

        public HttpClient build() {
            return new AndroidHttpClient(this.configureClient());
        }
    }
}

