/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.android.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;
import org.ektorp.http.HttpResponse;
import org.ektorp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidHttpResponse
implements HttpResponse {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidHttpResponse.class);
    private static final HttpEntity NULL_ENTITY = new NullEntity();
    private final HttpEntity entity;
    private final StatusLine status;
    private final String requestURI;
    private final HttpRequestBase httpRequest;
    private final String revision;

    public static AndroidHttpResponse of(org.apache.http.HttpResponse rsp, HttpRequestBase httpRequest) {
        return new AndroidHttpResponse(rsp.getEntity(), rsp.getStatusLine(), httpRequest, rsp.getFirstHeader("ETag"));
    }

    private AndroidHttpResponse(HttpEntity e, StatusLine status, HttpRequestBase httpRequest, Header eTagHeader) {
        this.httpRequest = httpRequest;
        this.entity = e != null ? e : NULL_ENTITY;
        this.status = status;
        this.requestURI = httpRequest.getURI().toString();
        this.revision = eTagHeader != null ? eTagHeader.getValue().replace("\"", "") : null;
    }

    public void abort() {
        this.httpRequest.abort();
    }

    public int getCode() {
        return this.status.getStatusCode();
    }

    public InputStream getContent() {
        try {
            return new ConnectionReleasingInputStream(this.entity.getContent());
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String getETag() {
        return this.revision;
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public String getContentType() {
        return this.entity.getContentType().getValue();
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public boolean isSuccessful() {
        return this.getCode() < 300;
    }

    public void releaseConnection() {
        try {
            this.entity.consumeContent();
        }
        catch (IOException e) {
            LOG.error("caught exception while releasing connection: {}", (Object)e.getMessage());
        }
    }

    private static class NullEntity
    implements HttpEntity {
        static final Header contentType = new BasicHeader("Content-Type", "null");
        static final Header contentEncoding = new BasicHeader("Content-Encoding", "UTF-8");

        private NullEntity() {
        }

        public void consumeContent() throws IOException {
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return null;
        }

        public Header getContentEncoding() {
            return contentEncoding;
        }

        public long getContentLength() {
            return 0L;
        }

        public Header getContentType() {
            return contentType;
        }

        public boolean isChunked() {
            return false;
        }

        public boolean isRepeatable() {
            return true;
        }

        public boolean isStreaming() {
            return false;
        }

        public void writeTo(OutputStream outstream) throws IOException {
            throw new UnsupportedOperationException("NullEntity cannot write");
        }
    }

    private class ConnectionReleasingInputStream
    extends FilterInputStream {
        private ConnectionReleasingInputStream(InputStream src) {
            super(src);
        }

        @Override
        public void close() throws IOException {
            AndroidHttpResponse.this.releaseConnection();
        }
    }
}

