/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.android.util;

import android.os.AsyncTask;
import org.ektorp.CouchDbConnector;
import org.ektorp.DbAccessException;
import org.ektorp.changes.ChangesCommand;
import org.ektorp.changes.ChangesFeed;
import org.ektorp.changes.DocumentChange;

public abstract class ChangesFeedAsyncTask
extends AsyncTask<Void, DocumentChange, Object> {
    protected CouchDbConnector couchDbConnector;
    protected ChangesCommand changesCommand;
    protected ChangesFeed changesFeed;

    public ChangesFeedAsyncTask(CouchDbConnector couchDbConnector, ChangesCommand changesCommand) {
        this.couchDbConnector = couchDbConnector;
        this.changesCommand = changesCommand;
    }

    protected Object doInBackground(Void ... params) {
        DbAccessException result = null;
        this.changesFeed = this.couchDbConnector.changesFeed(this.changesCommand);
        while (!this.isCancelled() && this.changesFeed.isAlive()) {
            try {
                DocumentChange change = this.changesFeed.next();
                this.publishProgress(new DocumentChange[]{change});
            }
            catch (DbAccessException dbAccesException) {
                result = dbAccesException;
            }
            catch (InterruptedException interruptedException) {
                this.cancel(false);
            }
        }
        return result;
    }

    protected void onCancelled() {
        if (this.changesFeed != null) {
            this.changesFeed.cancel();
        }
    }

    protected void onPostExecute(Object result) {
        if (result == null) {
            this.onSuccess();
        } else if (result instanceof DbAccessException) {
            this.onDbAccessException((DbAccessException)((Object)result));
        }
    }

    protected void onSuccess() {
    }

    protected void onDbAccessException(DbAccessException dbAccessException) {
        throw dbAccessException;
    }

    protected void onProgressUpdate(DocumentChange ... values) {
        this.handleDocumentChange(values[0]);
    }

    protected abstract void handleDocumentChange(DocumentChange var1);
}

