/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.android.util;

import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.List;
import org.ektorp.CouchDbConnector;
import org.ektorp.DbAccessException;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;
import org.ektorp.android.util.ChangesFeedAsyncTask;
import org.ektorp.android.util.EktorpAsyncTask;
import org.ektorp.changes.ChangesCommand;
import org.ektorp.changes.DocumentChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CouchbaseViewListAdapter
extends BaseAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseViewListAdapter.class);
    protected CouchDbConnector couchDbConnector;
    protected ViewQuery viewQuery;
    protected boolean followChanges;
    protected List<ViewResult.Row> listRows;
    protected long lastUpdateChangesFeed = -1L;
    protected long lastUpdateView = -1L;
    protected EktorpAsyncTask updateListItemsTask;
    protected CouchbaseListChangesAsyncTask couchChangesAsyncTask;

    public CouchbaseViewListAdapter(CouchDbConnector couchDbConnector, ViewQuery viewQuery, boolean followChanges) {
        this.couchDbConnector = couchDbConnector;
        this.viewQuery = viewQuery.updateSeq(true);
        this.followChanges = followChanges;
        this.listRows = new ArrayList<ViewResult.Row>();
        this.updateListItems();
    }

    public int getCount() {
        return this.listRows.size();
    }

    public Object getItem(int position) {
        return this.listRows.get(position);
    }

    public ViewResult.Row getRow(int position) {
        return (ViewResult.Row)this.getItem(position);
    }

    public long getItemId(int position) {
        return position;
    }

    protected void updateListItems() {
        if (this.updateListItemsTask == null) {
            this.updateListItemsTask = new EktorpAsyncTask(){
                protected ViewResult viewResult;

                @Override
                protected void doInBackground() {
                    this.viewResult = CouchbaseViewListAdapter.this.couchDbConnector.queryView(CouchbaseViewListAdapter.this.viewQuery);
                }

                @Override
                protected void onSuccess() {
                    if (this.viewResult != null) {
                        CouchbaseViewListAdapter.this.lastUpdateView = this.viewResult.getUpdateSeq();
                        CouchbaseViewListAdapter.this.listRows = this.viewResult.getRows();
                        CouchbaseViewListAdapter.this.notifyDataSetChanged();
                    }
                    CouchbaseViewListAdapter.this.updateListItemsTask = null;
                    if (CouchbaseViewListAdapter.this.couchChangesAsyncTask == null && CouchbaseViewListAdapter.this.followChanges) {
                        ChangesCommand changesCmd = new ChangesCommand.Builder().since(CouchbaseViewListAdapter.this.lastUpdateView).includeDocs(false).continuous(true).heartbeat(5000).build();
                        CouchbaseViewListAdapter.this.couchChangesAsyncTask = new CouchbaseListChangesAsyncTask(CouchbaseViewListAdapter.this.couchDbConnector, changesCmd);
                        CouchbaseViewListAdapter.this.couchChangesAsyncTask.execute(new Void[0]);
                    }
                    if (CouchbaseViewListAdapter.this.lastUpdateChangesFeed > CouchbaseViewListAdapter.this.lastUpdateView) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Finished, but still behind " + CouchbaseViewListAdapter.this.lastUpdateChangesFeed + " > " + CouchbaseViewListAdapter.this.lastUpdateView);
                        }
                        CouchbaseViewListAdapter.this.updateListItems();
                    }
                }

                @Override
                protected void onDbAccessException(DbAccessException dbAccessException) {
                    CouchbaseViewListAdapter.this.handleViewAsyncTaskDbAccessException(dbAccessException);
                }
            };
            this.updateListItemsTask.execute(new Void[0]);
        }
    }

    protected void handleViewAsyncTaskDbAccessException(DbAccessException dbAccessException) {
        LOG.error("DbAccessException accessing view for list", (Throwable)dbAccessException);
    }

    protected void handleChangesAsyncTaskDbAccessException(DbAccessException dbAccessException) {
        LOG.error("DbAccessException following changes feed for list", (Throwable)dbAccessException);
    }

    public void cancelContinuous() {
        if (this.couchChangesAsyncTask != null) {
            this.couchChangesAsyncTask.cancel(true);
        }
    }

    private class CouchbaseListChangesAsyncTask
    extends ChangesFeedAsyncTask {
        public CouchbaseListChangesAsyncTask(CouchDbConnector couchDbConnector, ChangesCommand changesCommand) {
            super(couchDbConnector, changesCommand);
        }

        @Override
        protected void handleDocumentChange(DocumentChange change) {
            CouchbaseViewListAdapter.this.lastUpdateChangesFeed = change.getSequence();
            CouchbaseViewListAdapter.this.updateListItems();
        }

        @Override
        protected void onDbAccessException(DbAccessException dbAccessException) {
            CouchbaseViewListAdapter.this.handleChangesAsyncTaskDbAccessException(dbAccessException);
        }
    }
}

