/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.server;

import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.Logging;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.elasticmq.Client;
import org.elasticmq.NodeBuilder$;
import org.elasticmq.replication.ReplicatedStorageConfigurator;
import org.elasticmq.rest.RestServer;
import org.elasticmq.rest.sqs.SQSRestServerBuilder;
import org.elasticmq.server.ElasticMQServerConfig;
import org.elasticmq.server.ElasticMQServerConfig$InMemoryStorage$;
import org.elasticmq.server.ElasticMQServerConfig$UDP$;
import org.elasticmq.server.Environment$;
import org.elasticmq.storage.StorageCommandExecutor;
import org.elasticmq.storage.filelog.FileLogConfiguration;
import org.elasticmq.storage.filelog.FileLogConfigurator;
import org.elasticmq.storage.inmemory.InMemoryStorage;
import org.elasticmq.storage.interfaced.InterfacedCommandExecutor;
import org.elasticmq.storage.squeryl.DBConfiguration;
import org.elasticmq.storage.squeryl.SquerylStorage;
import org.jgroups.JChannel;
import org.jgroups.protocols.TCP;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001%\u0011q\"\u00127bgRL7-T)TKJ4XM\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(BA\u0003\u0007\u0003%)G.Y:uS\u000el\u0017OC\u0001\b\u0003\ry'oZ\u0002\u0001'\r\u0001!B\u0005\t\u0003\u0017Ai\u0011\u0001\u0004\u0006\u0003\u001b9\tA\u0001\\1oO*\tq\"\u0001\u0003kCZ\f\u0017BA\t\r\u0005\u0019y%M[3diB\u00111\u0003H\u0007\u0002))\u0011QCF\u0001\u0006g24GG\u001b\u0006\u0003/a\tAb]2bY\u0006dwnZ4j]\u001eT!!\u0007\u000e\u0002\u0011QL\b/Z:bM\u0016T\u0011aG\u0001\u0004G>l\u0017BA\u000f\u0015\u0005\u001daunZ4j]\u001eD\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0007G>tg-[4\u0011\u0005\u0005\u0012S\"\u0001\u0002\n\u0005\r\u0012!!F#mCN$\u0018nY'R'\u0016\u0014h/\u001a:D_:4\u0017n\u001a\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001dB\u0003CA\u0011\u0001\u0011\u0015yB\u00051\u0001!\u0011\u0015Q\u0003\u0001\"\u0001,\u0003\u0015\u0019H/\u0019:u)\u0005a\u0003cA\u00171e5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdFA\u0005Gk:\u001cG/[8oaA\u0011QfM\u0005\u0003i9\u0012A!\u00168ji\")a\u0007\u0001C\u0005o\u0005i1M]3bi\u0016\u001cFo\u001c:bO\u0016$\u0012\u0001\u000f\t\u0003syj\u0011A\u000f\u0006\u0003wq\n!\"\u001b8uKJ4\u0017mY3e\u0015\tiD!A\u0004ti>\u0014\u0018mZ3\n\u0005}R$!G%oi\u0016\u0014h-Y2fI\u000e{W.\\1oI\u0016CXmY;u_JDQ!\u0011\u0001\u0005\n\t\u000b\u0011d\u001c9uS>t\u0017\r\u001c7z/J\f\u0007oV5uQ\u001aKG.\u001a'pOR\u00111i\u0012\t\u0003\t\u0016k\u0011\u0001P\u0005\u0003\rr\u0012ac\u0015;pe\u0006<WmQ8n[\u0006tG-\u0012=fGV$xN\u001d\u0005\u0006{\u0001\u0003\ra\u0011\u0005\u0006\u0013\u0002!IAS\u0001\u0017e\u0016\u0004H.Y2f\u0005\u0006\u001cX\rR5s\u0013\u001atU-\u001a3fIR\u00111*\u0015\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d:\t!![8\n\u0005Ak%\u0001\u0002$jY\u0016DQA\u0015%A\u0002-\u000bAAZ5mK\")A\u000b\u0001C\u0005+\u0006Qr\u000e\u001d;j_:\fG\u000e\\=Ti\u0006\u0014HOU3qY&\u001c\u0017\r^5p]R\u00111I\u0016\u0005\u0006{M\u0003\ra\u0011\u0005\u00061\u0002!I!W\u0001\u0019U\u000eD\u0017M\u001c8fY\u000e\u0013X-\u0019;j_:4UO\\2uS>tW#\u0001.\u0011\u00075\u00024\f\u0005\u0002]?6\tQL\u0003\u0002_\r\u00059!n\u001a:pkB\u001c\u0018B\u00011^\u0005!Q5\t[1o]\u0016d\u0007\"\u00022\u0001\t\u0013\u0019\u0017AG7f[\n,'o\u001d'jgRLeNS$s_V\u00048OR8s[\u0006$HC\u00013l!\t)\u0007N\u0004\u0002.M&\u0011qML\u0001\u0007!J,G-\u001a4\n\u0005%T'AB*ue&twM\u0003\u0002h]!)A.\u0019a\u0001[\u00069Q.Z7cKJ\u001c\bc\u00018wI:\u0011q\u000e\u001e\b\u0003aNl\u0011!\u001d\u0006\u0003e\"\ta\u0001\u0010:p_Rt\u0014\"A\u0018\n\u0005Ut\u0013a\u00029bG.\fw-Z\u0005\u0003ob\u0014A\u0001T5ti*\u0011QO\f\u0005\u0006u\u0002!Ia_\u0001\u0017_B$\u0018n\u001c8bY2L8\u000b^1siJ+7\u000f^*rgR\u0019A0a\u0003\u0011\u00075jx0\u0003\u0002\u007f]\t1q\n\u001d;j_:\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b!\u0011\u0001\u0002:fgRLA!!\u0003\u0002\u0004\tQ!+Z:u'\u0016\u0014h/\u001a:\t\u000buJ\b\u0019A\"")
public class ElasticMQServer
implements Logging {
    private final ElasticMQServerConfig config;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ElasticMQServer elasticMQServer = this;
        synchronized (elasticMQServer) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Function0<BoxedUnit> start() {
        InterfacedCommandExecutor baseStorage = this.createStorage();
        StorageCommandExecutor withOptionalFileLog = this.optionallyWrapWithFileLog((StorageCommandExecutor)baseStorage);
        StorageCommandExecutor withOptionalReplication = this.optionallyStartReplication(withOptionalFileLog);
        Option<RestServer> restServerOpt = this.optionallyStartRestSqs(withOptionalReplication);
        return new Serializable(this, withOptionalReplication, restServerOpt){
            public static final long serialVersionUID = 0L;
            private final StorageCommandExecutor withOptionalReplication$1;
            private final Option restServerOpt$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.restServerOpt$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(RestServer x$1) {
                        x$1.stop();
                    }
                });
                this.withOptionalReplication$1.shutdown();
            }
            {
                this.withOptionalReplication$1 = withOptionalReplication$1;
                this.restServerOpt$1 = restServerOpt$1;
            }
        };
    }

    private InterfacedCommandExecutor createStorage() {
        ElasticMQServerConfig.Storage storage;
        block4: {
            InMemoryStorage inMemoryStorage;
            block3: {
                ElasticMQServerConfig.DatabaseStorage x2;
                block2: {
                    storage = this.config.storage();
                    ElasticMQServerConfig$InMemoryStorage$ elasticMQServerConfig$InMemoryStorage$ = this.config.InMemoryStorage();
                    ElasticMQServerConfig.Storage storage2 = storage;
                    if (elasticMQServerConfig$InMemoryStorage$ != null ? !elasticMQServerConfig$InMemoryStorage$.equals(storage2) : storage2 != null) break block2;
                    ElasticMQServerConfig.Storage x3 = storage;
                    inMemoryStorage = new InMemoryStorage();
                    break block3;
                }
                if (!(storage instanceof ElasticMQServerConfig.DatabaseStorage) || (x2 = (ElasticMQServerConfig.DatabaseStorage)storage) == null) break block4;
                DBConfiguration dbConfiguration = x2.dbConfiguration();
                inMemoryStorage = new SquerylStorage(dbConfiguration);
            }
            return inMemoryStorage;
        }
        throw new MatchError((Object)storage);
    }

    private StorageCommandExecutor optionallyWrapWithFileLog(StorageCommandExecutor storage) {
        return this.config.fileLog().enabled() ? new FileLogConfigurator(storage, new FileLogConfiguration(this.replaceBaseDirIfNeeded(this.config.fileLog().storageDir()), this.config.fileLog().rotateLogsAfterCommandWritten())).start() : storage;
    }

    private File replaceBaseDirIfNeeded(File file) {
        File file2;
        String BaseDirToken = "$BASEDIR";
        String path = file.getPath();
        if (path.contains(BaseDirToken)) {
            String newPath = path.replace(BaseDirToken, Environment$.MODULE$.BaseDir());
            file2 = new File(newPath);
        } else {
            file2 = file;
        }
        return file2;
    }

    private StorageCommandExecutor optionallyStartReplication(StorageCommandExecutor storage) {
        return this.config.replication().enabled() ? new ReplicatedStorageConfigurator(storage, this.config.nodeAddress(), this.config.replication().commandReplicationMode(), this.config.replication().numberOfNodes(), this.jchannelCreationFunction()).start() : storage;
    }

    private Function0<JChannel> jchannelCreationFunction() {
        Option<File> option;
        block4: {
            ElasticMQServerConfig.NodeDiscovery nodeDiscovery;
            block7: {
                Object object;
                block3: {
                    Object object2;
                    block6: {
                        ElasticMQServerConfig.TCP x2;
                        block5: {
                            block2: {
                                Some x22;
                                option = this.config.replication().customJGroupsStackConfigurationFile();
                                if (!(option instanceof Some) || (x22 = (Some)option) == null) break block2;
                                File file = (File)x22.x();
                                object = new Serializable(this, file){
                                    public static final long serialVersionUID = 0L;
                                    private final File file$1;

                                    public final JChannel apply() {
                                        return new JChannel(this.file$1);
                                    }
                                    {
                                        this.file$1 = file$1;
                                    }
                                };
                                break block3;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<File> option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                            Option<File> x3 = option;
                            nodeDiscovery = this.config.replication().nodeDiscovery();
                            ElasticMQServerConfig$UDP$ elasticMQServerConfig$UDP$ = this.config.UDP();
                            ElasticMQServerConfig.NodeDiscovery nodeDiscovery2 = nodeDiscovery;
                            if (elasticMQServerConfig$UDP$ != null ? !elasticMQServerConfig$UDP$.equals(nodeDiscovery2) : nodeDiscovery2 != null) break block5;
                            ElasticMQServerConfig.NodeDiscovery x32 = nodeDiscovery;
                            object2 = new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final JChannel apply() {
                                    return new JChannel();
                                }
                            };
                            break block6;
                        }
                        if (!(nodeDiscovery instanceof ElasticMQServerConfig.TCP) || (x2 = (ElasticMQServerConfig.TCP)nodeDiscovery) == null) break block7;
                        List<String> initialMembers = x2.initialMembers();
                        String replicationBindAddress = x2.replicationBindAddress();
                        object2 = new Serializable(this, initialMembers, replicationBindAddress){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ElasticMQServer $outer;
                            private final List initialMembers$1;
                            private final String replicationBindAddress$1;

                            /*
                             * WARNING - void declaration
                             */
                            public final JChannel apply() {
                                void var2_2;
                                String[] hostAndPort = this.replicationBindAddress$1.split(":");
                                System.setProperty("jgroups.bind_addr", hostAndPort[0]);
                                System.setProperty("jgroups.tcpping.initial_hosts", this.$outer.org$elasticmq$server$ElasticMQServer$$membersListInJGroupsFormat((List<String>)this.initialMembers$1));
                                JChannel channel = new JChannel("tcp.xml");
                                ((TCP)channel.getProtocolStack().findProtocol(TCP.class)).setBindPort(new StringOps(Predef$.MODULE$.augmentString(hostAndPort[1])).toInt());
                                return var2_2;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.initialMembers$1 = initialMembers$1;
                                this.replicationBindAddress$1 = replicationBindAddress$1;
                            }
                        };
                    }
                    object = object2;
                }
                return object;
            }
            throw new MatchError((Object)nodeDiscovery);
        }
        throw new MatchError(option);
    }

    public String org$elasticmq$server$ElasticMQServer$$membersListInJGroupsFormat(List<String> members) {
        return ((TraversableOnce)members.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String member) {
                String[] parts = member.split(":");
                return Predef$.MODULE$.refArrayOps((Object[])parts).size() == 1 ? member : new StringBuilder().append((Object)parts[0]).append((Object)"[").append((Object)parts[1]).append((Object)"]").toString();
            }
        }, List$.MODULE$.canBuildFrom())).mkString(",");
    }

    private Option<RestServer> optionallyStartRestSqs(StorageCommandExecutor storage) {
        None$ none$;
        if (this.config.restSqs().enabled()) {
            Client client = NodeBuilder$.MODULE$.withStorage(storage).nativeClient();
            RestServer server = new SQSRestServerBuilder(client, (SocketAddress)new InetSocketAddress(this.config.restSqs().bindHostname(), this.config.restSqs().bindPort()), this.config.nodeAddress(), this.config.restSqs().sqsLimits()).start();
            none$ = new Some((Object)server);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public ElasticMQServer(ElasticMQServerConfig config) {
        this.config = config;
        Logging.class.$init$((Logging)this);
    }
}

