/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.server;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.Logging;
import java.io.File;
import java.io.InputStream;
import org.elasticmq.server.ElasticMQServer;
import org.elasticmq.server.ElasticMQServerConfig;
import org.elasticmq.server.Environment$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Main$
implements Logging {
    public static final Main$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new Main$();
    }

    private Logger logger$lzycompute() {
        Main$ main$ = this;
        synchronized (main$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void main(String[] args) {
        long start2 = System.currentTimeMillis();
        String version = this.readVersion();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringOps(Predef$.MODULE$.augmentString("Starting ElasticMQ server (%s) ...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version})));
        }
        this.logUncaughtExceptions();
        String configFile = new StringBuilder().append((Object)Environment$.MODULE$.BaseDir()).append((Object)File.separator).append((Object)"conf").append((Object)File.separator).append((Object)"elasticmq.conf").toString();
        Config config = ConfigFactory.parseFile((File)new File(configFile));
        ElasticMQServer server = new ElasticMQServer(new ElasticMQServerConfig(config));
        Function0<BoxedUnit> shutdown = server.start();
        this.addShutdownHook(shutdown);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringOps(Predef$.MODULE$.augmentString("=== ElasticMQ server (%s) started in %d ms ===")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - start2))})));
        }
    }

    private String readVersion() {
        InputStream stream = this.getClass().getResourceAsStream("/version");
        return (String)Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec()).getLines().next();
    }

    private void logUncaughtExceptions() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                if (Main$.MODULE$.logger().underlying().isErrorEnabled()) {
                    Main$.MODULE$.logger().underlying().error(new StringBuilder().append((Object)"Uncaught exception in thread: ").append((Object)t.getName()).toString(), e);
                }
            }
        });
    }

    private void addShutdownHook(Function0<BoxedUnit> shutdown) {
        Runtime.getRuntime().addShutdownHook(new Thread(shutdown){
            private final Function0 shutdown$1;

            public void run() {
                if (Main$.MODULE$.logger().underlying().isInfoEnabled()) {
                    Main$.MODULE$.logger().underlying().info("ElasticMQ server stopping ...");
                }
                this.shutdown$1.apply$mcV$sp();
                if (Main$.MODULE$.logger().underlying().isInfoEnabled()) {
                    Main$.MODULE$.logger().underlying().info("=== ElasticMQ server stopped ===");
                }
            }
            {
                this.shutdown$1 = shutdown$1;
            }
        });
    }

    private Main$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

