/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.server;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.Props$;
import akka.actor.Terminated;
import akka.util.Timeout;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.elasticmq.DeadLettersQueueData;
import org.elasticmq.ElasticMQError;
import org.elasticmq.MillisVisibilityTimeout$;
import org.elasticmq.QueueData;
import org.elasticmq.actor.QueueManagerActor;
import org.elasticmq.actor.reply.Replyable;
import org.elasticmq.rest.sqs.CreateQueueDirectives$;
import org.elasticmq.rest.sqs.SQSRestServer;
import org.elasticmq.rest.sqs.TheSQSRestServerBuilder;
import org.elasticmq.server.config.CreateQueue;
import org.elasticmq.server.config.DeadLettersQueue;
import org.elasticmq.server.config.ElasticMQServerConfig;
import org.elasticmq.util.Logging;
import org.elasticmq.util.NowProvider;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.UninitializedFieldError;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u0013\tyQ\t\\1ti&\u001cW*U*feZ,'O\u0003\u0002\u0004\t\u000511/\u001a:wKJT!!\u0002\u0004\u0002\u0013\u0015d\u0017m\u001d;jG6\f(\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Q\u0001\u0003\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0011\tA!\u001e;jY&\u0011QC\u0005\u0002\b\u0019><w-\u001b8h\u0011!9\u0002A!A!\u0002\u0013A\u0012AB2p]\u001aLw\r\u0005\u0002\u001a75\t!D\u0003\u0002\u0018\u0005%\u0011AD\u0007\u0002\u0016\u000b2\f7\u000f^5d\u001bF\u001bVM\u001d<fe\u000e{gNZ5h\u0011\u0015q\u0002\u0001\"\u0001 \u0003\u0019a\u0014N\\5u}Q\u0011\u0001E\t\t\u0003C\u0001i\u0011A\u0001\u0005\u0006/u\u0001\r\u0001\u0007\u0005\bI\u0001\u0011\r\u0011\"\u0001&\u0003-\t7\r^8s'f\u001cH/Z7\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003-\nA!Y6lC&\u0011Q\u0006\u000b\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u00040\u0001\u0001\u0006IAJ\u0001\rC\u000e$xN]*zgR,W\u000e\t\u0005\u0006c\u0001!\tAM\u0001\u0006gR\f'\u000f\u001e\u000b\u0002gA\u00191\u0002\u000e\u001c\n\u0005Ub!!\u0003$v]\u000e$\u0018n\u001c81!\t9s'\u0003\u00029Q\tQA+\u001a:nS:\fG/\u001a3\t\u000bi\u0002A\u0011B\u001e\u0002\u0015\r\u0014X-\u0019;f\u0005\u0006\u001cX\rF\u0001=!\t9S(\u0003\u0002?Q\tA\u0011i\u0019;peJ+g\rC\u0003A\u0001\u0011%\u0011)\u0001\fpaRLwN\\1mYf\u001cF/\u0019:u%\u0016\u001cHoU9t)\t\u0011U\nE\u0002\f\u0007\u0016K!\u0001\u0012\u0007\u0003\r=\u0003H/[8o!\t15*D\u0001H\u0015\tA\u0015*A\u0002tcNT!A\u0013\u0003\u0002\tI,7\u000f^\u0005\u0003\u0019\u001e\u0013QbU)T%\u0016\u001cHoU3sm\u0016\u0014\b\"\u0002(@\u0001\u0004a\u0014!E9vKV,W*\u00198bO\u0016\u0014\u0018i\u0019;pe\")\u0001\u000b\u0001C\u0005#\u0006a1M]3bi\u0016\fV/Z;fgR\u0011!+\u0016\t\u0003\u0017MK!\u0001\u0016\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001d>\u0003\r\u0001\u0010\u0005\u0006/\u0002!I\u0001W\u0001\u000fG>tg-[4U_B\u000b'/Y7t)\rIVL\u0019\t\u00035nk\u0011\u0001B\u0005\u00039\u0012\u0011\u0011\"U;fk\u0016$\u0015\r^1\t\u000by3\u0006\u0019A0\u0002\u0005\r\f\bCA\ra\u0013\t\t'DA\u0006De\u0016\fG/Z)vKV,\u0007\"B2W\u0001\u0004!\u0017a\u00018poB\u0011QM[\u0007\u0002M*\u0011q\r[\u0001\u0005i&lWM\u0003\u0002j\r\u0005!!n\u001c3b\u0013\tYgM\u0001\u0005ECR,G+[7f\u0001")
public class ElasticMQServer
implements Logging {
    private final ElasticMQServerConfig config;
    private final ActorSystem actorSystem;
    private final transient Logger logger;
    private volatile boolean bitmap$init$0;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ElasticMQServer elasticMQServer = this;
        synchronized (elasticMQServer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public ActorSystem actorSystem() {
        if (this.bitmap$init$0) {
            return this.actorSystem;
        }
        throw new UninitializedFieldError("Uninitialized field: ElasticMQServer.scala: 17");
    }

    public Function0<Terminated> start() {
        ActorRef queueManagerActor = this.createBase();
        Option<SQSRestServer> restServerOpt = this.optionallyStartRestSqs(queueManagerActor);
        this.createQueues(queueManagerActor);
        return new Serializable(this, restServerOpt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ElasticMQServer $outer;
            private final Option restServerOpt$1;

            public final Terminated apply() {
                this.restServerOpt$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Future<Object> apply(SQSRestServer x$1) {
                        return (Future)x$1.stopAndGetFuture().apply();
                    }
                });
                return (Terminated)Await$.MODULE$.result((Awaitable)this.$outer.actorSystem().terminate(), (Duration)Duration$.MODULE$.Inf());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.restServerOpt$1 = restServerOpt$1;
            }
        };
    }

    private ActorRef createBase() {
        ElasticMQServerConfig.Storage storage = this.config.storage();
        if (this.config.InMemoryStorage().equals(storage)) {
            ActorRef actorRef = this.actorSystem().actorOf(Props$.MODULE$.apply((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final QueueManagerActor apply() {
                    return new QueueManagerActor(new NowProvider());
                }
            }, ClassTag$.MODULE$.apply(QueueManagerActor.class)));
            return actorRef;
        }
        throw new MatchError((Object)storage);
    }

    private Option<SQSRestServer> optionallyStartRestSqs(ActorRef queueManagerActor) {
        None$ none$;
        if (this.config.restSqs().enabled()) {
            SQSRestServer server = new TheSQSRestServerBuilder((Option)new Some((Object)this.actorSystem()), (Option)new Some((Object)queueManagerActor), this.config.restSqs().bindHostname(), this.config.restSqs().bindPort(), this.config.nodeAddress(), this.config.generateNodeAddress(), this.config.restSqs().sqsLimits()).start();
            server.waitUntilStarted();
            none$ = new Some((Object)server);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void createQueues(ActorRef queueManagerActor) {
        Timeout timeout = new Timeout(new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
        this.config.createQueues().foreach((Function1)new Serializable(this, queueManagerActor, timeout){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ElasticMQServer $outer;
            private final ActorRef queueManagerActor$1;
            private final Timeout timeout$1;

            public final Either<ElasticMQError, ActorRef> apply(CreateQueue cq) {
                Future f = org.elasticmq.actor.reply.package$.MODULE$.ReplyActorRef(this.queueManagerActor$1).$qmark((Replyable)new org.elasticmq.msg.CreateQueue(this.$outer.org$elasticmq$server$ElasticMQServer$$configToParams(cq, new DateTime())), this.timeout$1, ClassTag$.MODULE$.apply(Either.class));
                return (Either)Await$.MODULE$.result((Awaitable)f, (Duration)this.timeout$1.duration());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queueManagerActor$1 = queueManagerActor$1;
                this.timeout$1 = timeout$1;
            }
        });
    }

    public QueueData org$elasticmq$server$ElasticMQServer$$configToParams(CreateQueue cq, DateTime now) {
        return new QueueData(cq.name(), MillisVisibilityTimeout$.MODULE$.fromSeconds(BoxesRunTime.unboxToLong((Object)cq.defaultVisibilityTimeoutSeconds().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return CreateQueueDirectives$.MODULE$.DefaultVisibilityTimeout();
            }
        }))), org.joda.time.Duration.standardSeconds((long)BoxesRunTime.unboxToLong((Object)cq.delaySeconds().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return CreateQueueDirectives$.MODULE$.DefaultDelay();
            }
        }))), org.joda.time.Duration.standardSeconds((long)BoxesRunTime.unboxToLong((Object)cq.receiveMessageWaitSeconds().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return CreateQueueDirectives$.MODULE$.DefaultReceiveMessageWait();
            }
        }))), now, now, cq.deadLettersQueue().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DeadLettersQueueData apply(DeadLettersQueue dlq) {
                return new DeadLettersQueueData(dlq.name(), dlq.maxReceiveCount());
            }
        }), cq.isFifo(), cq.hasContentBasedDeduplication(), cq.copyMessagesTo(), cq.moveMessagesTo());
    }

    public ElasticMQServer(ElasticMQServerConfig config) {
        this.config = config;
        LazyLogging.class.$init$((LazyLogging)this);
        this.actorSystem = ActorSystem$.MODULE$.apply("elasticmq");
        this.bitmap$init$0 = true;
    }
}

