/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.server;

import akka.actor.Terminated;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import org.elasticmq.server.ElasticMQServer;
import org.elasticmq.server.config.ElasticMQServerConfig;
import org.elasticmq.util.Logging;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Main$
implements Logging {
    public static Main$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new Main$();
    }

    private Logger logger$lzycompute() {
        Main$ main$ = this;
        synchronized (main$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void main(String[] args) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        long start = System.currentTimeMillis();
        String version = this.readVersion();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringOps(Predef$.MODULE$.augmentString("Starting ElasticMQ server (%s) ...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.logUncaughtExceptions();
        Config config = ConfigFactory.load();
        ElasticMQServer server = new ElasticMQServer(new ElasticMQServerConfig(config));
        Function0<Terminated> shutdown = server.start();
        this.addShutdownHook(shutdown);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringOps(Predef$.MODULE$.augmentString("=== ElasticMQ server (%s) started in %d ms ===")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - start))})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private String readVersion() {
        InputStream stream = this.getClass().getResourceAsStream("/version");
        return (String)Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec()).getLines().next();
    }

    private void logUncaughtExceptions() {
        Thread.setDefaultUncaughtExceptionHandler((thread, ex) -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error(new StringBuilder(30).append("Uncaught exception in thread: ").append(thread.getName()).toString(), ex);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        });
    }

    private void addShutdownHook(Function0<Terminated> shutdown) {
        Runtime.getRuntime().addShutdownHook(new Thread(shutdown){
            private final Function0 shutdown$1;

            public void run() {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                if (Main$.MODULE$.logger().underlying().isInfoEnabled()) {
                    Main$.MODULE$.logger().underlying().info("ElasticMQ server stopping ...");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.shutdown$1.apply();
                if (Main$.MODULE$.logger().underlying().isInfoEnabled()) {
                    Main$.MODULE$.logger().underlying().info("=== ElasticMQ server stopped ===");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.shutdown$1 = shutdown$1;
            }
        });
    }

    private Main$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

