/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.server;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.Props$;
import akka.actor.Terminated;
import akka.util.Timeout;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.elasticmq.DeadLettersQueueData;
import org.elasticmq.ElasticMQError;
import org.elasticmq.Limits;
import org.elasticmq.MillisVisibilityTimeout$;
import org.elasticmq.QueueData;
import org.elasticmq.actor.QueueManagerActor;
import org.elasticmq.actor.reply.Replyable;
import org.elasticmq.rest.sqs.CreateQueueDirectives$;
import org.elasticmq.rest.sqs.SQSRestServer;
import org.elasticmq.rest.sqs.TheSQSRestServerBuilder;
import org.elasticmq.rest.stats.StatisticsRestServer;
import org.elasticmq.rest.stats.TheStatisticsRestServerBuilder;
import org.elasticmq.server.config.CreateQueue;
import org.elasticmq.server.config.ElasticMQServerConfig;
import org.elasticmq.util.Logging;
import org.elasticmq.util.NowProvider;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\u0006\r\u0001MA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006M\u0001!\ta\n\u0005\bW\u0001\u0011\r\u0011\"\u0001-\u0011\u0019)\u0004\u0001)A\u0005[!)a\u0007\u0001C\u0001o!)a\b\u0001C\u0005\u007f!)1\t\u0001C\u0005\t\")!\u000b\u0001C\u0005'\")A\f\u0001C\u0005;\")q\u000e\u0001C\u0005a\nyQ\t\\1ti&\u001cW*U*feZ,'O\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT!a\u0004\t\u0002\u0013\u0015d\u0017m\u001d;jG6\f(\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!\"\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037yi\u0011\u0001\b\u0006\u0003;9\tA!\u001e;jY&\u0011q\u0004\b\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u0011!\u0005J\u0007\u0002G)\u0011\u0001\u0005D\u0005\u0003K\r\u0012Q#\u00127bgRL7-T)TKJ4XM]\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0003Q)\u0002\"!\u000b\u0001\u000e\u00031AQ\u0001\t\u0002A\u0002\u0005\n1\"Y2u_J\u001c\u0016p\u001d;f[V\tQ\u0006\u0005\u0002/g5\tqF\u0003\u00021c\u0005)\u0011m\u0019;pe*\t!'\u0001\u0003bW.\f\u0017B\u0001\u001b0\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u0019\u0005\u001cGo\u001c:TsN$X-\u001c\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0003a\u00022!F\u001d<\u0013\tQdCA\u0005Gk:\u001cG/[8oaA\u0011a\u0006P\u0005\u0003{=\u0012!\u0002V3s[&t\u0017\r^3e\u0003)\u0019'/Z1uK\n\u000b7/\u001a\u000b\u0002\u0001B\u0011a&Q\u0005\u0003\u0005>\u0012\u0001\"Q2u_J\u0014VMZ\u0001\u0017_B$\u0018n\u001c8bY2L8\u000b^1siJ+7\u000f^*rgR\u0011Q\t\u0015\t\u0004+\u0019C\u0015BA$\u0017\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\u0004gF\u001c(BA'\u000f\u0003\u0011\u0011Xm\u001d;\n\u0005=S%!D*R'J+7\u000f^*feZ,'\u000fC\u0003R\u000f\u0001\u0007\u0001)A\trk\u0016,X-T1oC\u001e,'/Q2u_J\fQd\u001c9uS>t\u0017\r\u001c7z'R\f'\u000f\u001e*fgR\u001cF/\u0019;jgRL7m\u001d\u000b\u0003)n\u00032!\u0006$V!\t1\u0016,D\u0001X\u0015\tAF*A\u0003ti\u0006$8/\u0003\u0002[/\n!2\u000b^1uSN$\u0018nY:SKN$8+\u001a:wKJDQ!\u0015\u0005A\u0002\u0001\u000bAb\u0019:fCR,\u0017+^3vKN$\"A\u00188\u0011\u0007};'N\u0004\u0002aK:\u0011\u0011\rZ\u0007\u0002E*\u00111ME\u0001\u0007yI|w\u000e\u001e \n\u0003]I!A\u001a\f\u0002\u000fA\f7m[1hK&\u0011\u0001.\u001b\u0002\u0005\u0019&\u001cHO\u0003\u0002g-A\u00111\u000e\\\u0007\u0002\u001d%\u0011QN\u0004\u0002\u000f\u000b2\f7\u000f^5d\u001bF+%O]8s\u0011\u0015\t\u0016\u00021\u0001A\u00039\u0019wN\u001c4jOR{\u0007+\u0019:b[N$2!\u001d;z!\tY'/\u0003\u0002t\u001d\tI\u0011+^3vK\u0012\u000bG/\u0019\u0005\u0006k*\u0001\rA^\u0001\u0003GF\u0004\"AI<\n\u0005a\u001c#aC\"sK\u0006$X-U;fk\u0016DQA\u001f\u0006A\u0002m\f1A\\8x!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0005i&lWMC\u0002\u0002\u0002A\tAA[8eC&\u0019\u0011QA?\u0003\u0011\u0011\u000bG/\u001a+j[\u0016\u0004")
public class ElasticMQServer
implements Logging {
    private final ElasticMQServerConfig config;
    private final ActorSystem actorSystem;
    private transient Logger logger;
    private volatile boolean bitmap$init$0;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ElasticMQServer elasticMQServer = this;
        synchronized (elasticMQServer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ActorSystem actorSystem() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/adamw/projects/elasticmq/trunk/server/src/main/scala/org/elasticmq/server/ElasticMQServer.scala: 18");
        }
        return this.actorSystem;
    }

    public Function0<Terminated> start() {
        Object object;
        ActorRef queueManagerActor = this.createBase();
        Option<SQSRestServer> restServerOpt = this.optionallyStartRestSqs(queueManagerActor);
        Option<StatisticsRestServer> restStatisticsServerOpt = this.optionallyStartRestStatistics(queueManagerActor);
        Function0 & Serializable shutdown = (Function0 & Serializable)() -> {
            ExecutionContextExecutor ec = this.actorSystem().dispatcher();
            Future futureTerminationRestSQS = (Future)restServerOpt.map((Function1 & Serializable)x$1 -> (Future)x$1.stopAndGetFuture().apply()).getOrElse((Function0 & Serializable)() -> Future$.MODULE$.unit());
            Future futureTerminationRestStats = (Future)restStatisticsServerOpt.map((Function1 & Serializable)x$2 -> (Future)x$2.stopAndGetFuture().apply()).getOrElse((Function0 & Serializable)() -> Future$.MODULE$.unit());
            Future eventualTerminated = futureTerminationRestSQS.flatMap((Function1 & Serializable)x$4 -> {
                Object object = x$4;
                Future future = futureTerminationRestStats.flatMap((Function1 & Serializable)x$3 -> {
                    Object object = x$3;
                    Future future = this.actorSystem().terminate().map((Function1 & Serializable)ac -> ac, (ExecutionContext)ec);
                    return future;
                }, (ExecutionContext)ec);
                return future;
            }, (ExecutionContext)ec);
            return (Terminated)Await$.MODULE$.result((Awaitable)eventualTerminated, (Duration)Duration$.MODULE$.Inf());
        };
        List<ElasticMQError> list = this.createQueues(queueManagerActor);
        Nil$ nil$ = package$.MODULE$.Nil();
        List<ElasticMQError> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            object = BoxedUnit.UNIT;
        } else {
            list.foreach((Function1 & Serializable)error -> {
                ElasticMQServer.$anonfun$start$9(this, error);
                return BoxedUnit.UNIT;
            });
            object = shutdown.apply();
        }
        return shutdown;
    }

    private ActorRef createBase() {
        ElasticMQServerConfig.Storage storage = this.config.storage();
        if (!this.config.InMemoryStorage().equals(storage)) {
            throw new MatchError((Object)storage);
        }
        ActorRef actorRef = this.actorSystem().actorOf(Props$.MODULE$.apply((Function0 & Serializable)() -> new QueueManagerActor(new NowProvider(), (Limits)$this.config.restSqs().sqsLimits()), ClassTag$.MODULE$.apply(QueueManagerActor.class)));
        return actorRef;
    }

    private Option<SQSRestServer> optionallyStartRestSqs(ActorRef queueManagerActor) {
        None$ none$;
        if (this.config.restSqs().enabled()) {
            SQSRestServer server = new TheSQSRestServerBuilder((Option)new Some((Object)this.actorSystem()), (Option)new Some((Object)queueManagerActor), this.config.restSqs().bindHostname(), this.config.restSqs().bindPort(), this.config.nodeAddress(), this.config.generateNodeAddress(), (Limits)this.config.restSqs().sqsLimits(), this.config.awsRegion(), this.config.awsAccountId()).start();
            server.waitUntilStarted();
            none$ = new Some((Object)server);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<StatisticsRestServer> optionallyStartRestStatistics(ActorRef queueManagerActor) {
        None$ none$;
        if (this.config.restStatisticsConfiguration().enabled()) {
            StatisticsRestServer server = new TheStatisticsRestServerBuilder(this.actorSystem(), queueManagerActor, this.config.restStatisticsConfiguration().bindHostname(), this.config.restStatisticsConfiguration().bindPort(), this.config.awsRegion(), this.config.awsAccountId()).start();
            server.waitUntilStarted();
            none$ = new Some((Object)server);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private List<ElasticMQError> createQueues(ActorRef queueManagerActor) {
        Timeout timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds());
        return this.config.createQueues().flatMap((Function1 & Serializable)cq -> ((Either)Await$.MODULE$.result((Awaitable)org.elasticmq.actor.reply.package$.MODULE$.ReplyActorRef(queueManagerActor).$qmark((Replyable)new org.elasticmq.msg.CreateQueue(this.configToParams((CreateQueue)cq, new DateTime())), timeout, ClassTag$.MODULE$.apply(Either.class)), (Duration)timeout.duration())).swap().toOption());
    }

    private QueueData configToParams(CreateQueue cq, DateTime now) {
        return new QueueData(cq.name(), MillisVisibilityTimeout$.MODULE$.fromSeconds(BoxesRunTime.unboxToLong((Object)cq.defaultVisibilityTimeoutSeconds().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> CreateQueueDirectives$.MODULE$.DefaultVisibilityTimeout()))), org.joda.time.Duration.standardSeconds((long)BoxesRunTime.unboxToLong((Object)cq.delaySeconds().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> CreateQueueDirectives$.MODULE$.DefaultDelay()))), org.joda.time.Duration.standardSeconds((long)BoxesRunTime.unboxToLong((Object)cq.receiveMessageWaitSeconds().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> CreateQueueDirectives$.MODULE$.DefaultReceiveMessageWait()))), now, now, cq.deadLettersQueue().map((Function1 & Serializable)dlq -> new DeadLettersQueueData(dlq.name(), dlq.maxReceiveCount())), cq.isFifo(), cq.hasContentBasedDeduplication(), cq.copyMessagesTo(), cq.moveMessagesTo(), cq.tags());
    }

    public static final /* synthetic */ void $anonfun$start$9(ElasticMQServer $this, ElasticMQError error) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isErrorEnabled()) {
            $this.logger().underlying().error("Could not start server because {}", (Object)error);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ElasticMQServer(ElasticMQServerConfig config) {
        this.config = config;
        LazyLogging.$init$((LazyLogging)this);
        this.actorSystem = ActorSystem$.MODULE$.apply("elasticmq");
        this.bitmap$init$0 = true;
    }
}

