/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.server;

import akka.actor.Terminated;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import org.elasticmq.server.ElasticMQServer;
import org.elasticmq.server.config.ElasticMQServerConfig;
import org.elasticmq.util.Logging;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Main$
implements Logging {
    public static final Main$ MODULE$ = new Main$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        Main$ main$ = this;
        synchronized (main$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    public void main(String[] args) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        long start = System.currentTimeMillis();
        String version = this.readVersion();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Starting ElasticMQ server (%s) ..."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{version})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.logUncaughtExceptions();
        Config config = ConfigFactory.load();
        ElasticMQServer server = new ElasticMQServer(new ElasticMQServerConfig(config));
        Function0<Terminated> shutdown = server.start();
        this.addShutdownHook(shutdown);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("=== ElasticMQ server (%s) started in %d ms ==="), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{version, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - start))})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private String readVersion() {
        InputStream stream = this.getClass().getResourceAsStream("/version");
        return (String)Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec()).getLines().next();
    }

    private void logUncaughtExceptions() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                BoxedUnit boxedUnit;
                if (Main$.MODULE$.logger().underlying().isErrorEnabled()) {
                    Main$.MODULE$.logger().underlying().error(new StringBuilder(30).append("Uncaught exception in thread: ").append(t.getName()).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        });
    }

    private void addShutdownHook(Function0<Terminated> shutdown) {
        Runtime.getRuntime().addShutdownHook(new Thread(shutdown){
            private final Function0 shutdown$1;

            public void run() {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                if (Main$.MODULE$.logger().underlying().isInfoEnabled()) {
                    Main$.MODULE$.logger().underlying().info("ElasticMQ server stopping ...");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.shutdown$1.apply();
                if (Main$.MODULE$.logger().underlying().isInfoEnabled()) {
                    Main$.MODULE$.logger().underlying().info("=== ElasticMQ server stopped ===");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.shutdown$1 = shutdown$1;
            }
        });
    }

    private Main$() {
    }
}

