/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.dic;

import java.io.IOException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.wltea.analyzer.dic.Dictionary;

public class Monitor
implements Runnable {
    public static ESLogger logger = Loggers.getLogger((String)"ik-analyzer");
    private static CloseableHttpClient httpclient = HttpClients.createDefault();
    private String last_modified;
    private String eTags;
    private String location;

    public Monitor(String location) {
        this.location = location;
        this.last_modified = null;
        this.eTags = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RequestConfig rc = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(15000).build();
        HttpHead head = new HttpHead(this.location);
        head.setConfig(rc);
        if (this.last_modified != null) {
            head.setHeader("If-Modified-Since", this.last_modified);
        }
        if (this.eTags != null) {
            head.setHeader("If-None-Match", this.eTags);
        }
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)head);
            if (response.getStatusLine().getStatusCode() == 200) {
                if (response.getLastHeader("Last-Modified") != null && !response.getLastHeader("Last-Modified").getValue().equalsIgnoreCase(this.last_modified) || response.getLastHeader("ETag") != null && !response.getLastHeader("ETag").getValue().equalsIgnoreCase(this.eTags)) {
                    Dictionary.getSingleton().reLoadMainDict();
                    this.last_modified = response.getLastHeader("Last-Modified") == null ? null : response.getLastHeader("Last-Modified").getValue();
                    this.eTags = response.getLastHeader("ETag") == null ? null : response.getLastHeader("ETag").getValue();
                }
            } else if (response.getStatusLine().getStatusCode() == 304) {
            } else {
                Dictionary.logger.info("remote_ext_dict {} return bad code {}", new Object[]{this.location, response.getStatusLine().getStatusCode()});
            }
        }
        catch (Exception e) {
            Dictionary.logger.error("remote_ext_dict {} error!", (Throwable)e, new Object[]{this.location});
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
    }
}

