/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.dic;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.plugin.analysis.ik.AnalysisIkPlugin;
import org.wltea.analyzer.cfg.Configuration;
import org.wltea.analyzer.dic.DictSegment;
import org.wltea.analyzer.dic.Hit;
import org.wltea.analyzer.dic.Monitor;

public class Dictionary {
    private static Dictionary singleton;
    private DictSegment _MainDict;
    private DictSegment _SurnameDict;
    private DictSegment _QuantifierDict;
    private DictSegment _SuffixDict;
    private DictSegment _PrepDict;
    private DictSegment _StopWords;
    private Configuration configuration;
    private static final Logger logger;
    private static ScheduledExecutorService pool;
    public static final String PATH_DIC_MAIN = "main.dic";
    public static final String PATH_DIC_SURNAME = "surname.dic";
    public static final String PATH_DIC_QUANTIFIER = "quantifier.dic";
    public static final String PATH_DIC_SUFFIX = "suffix.dic";
    public static final String PATH_DIC_PREP = "preposition.dic";
    public static final String PATH_DIC_STOP = "stopword.dic";
    private static final String FILE_NAME = "IKAnalyzer.cfg.xml";
    private static final String EXT_DICT = "ext_dict";
    private static final String REMOTE_EXT_DICT = "remote_ext_dict";
    private static final String EXT_STOP = "ext_stopwords";
    private static final String REMOTE_EXT_STOP = "remote_ext_stopwords";
    private Path conf_dir;
    private Properties props;

    private Dictionary(Configuration cfg) {
        this.configuration = cfg;
        this.props = new Properties();
        this.conf_dir = cfg.getEnvironment().configFile().resolve(AnalysisIkPlugin.PLUGIN_NAME);
        Path configFile = this.conf_dir.resolve(FILE_NAME);
        FileInputStream input = null;
        try {
            logger.info("try load config from {}", new Object[]{configFile});
            input = new FileInputStream(configFile.toFile());
        }
        catch (FileNotFoundException e) {
            this.conf_dir = cfg.getConfigInPluginDir();
            configFile = this.conf_dir.resolve(FILE_NAME);
            try {
                logger.info("try load config from {}", new Object[]{configFile});
                input = new FileInputStream(configFile.toFile());
            }
            catch (FileNotFoundException ex) {
                logger.error("ik-analyzer", (Throwable)e);
            }
        }
        if (input != null) {
            try {
                this.props.loadFromXML(input);
            }
            catch (InvalidPropertiesFormatException e) {
                logger.error("ik-analyzer", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("ik-analyzer", (Throwable)e);
            }
        }
    }

    public String getProperty(String key) {
        if (this.props != null) {
            return this.props.getProperty(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Dictionary initial(Configuration cfg) {
        if (singleton != null) return singleton;
        Class<Dictionary> clazz = Dictionary.class;
        synchronized (Dictionary.class) {
            if (singleton != null) return singleton;
            singleton = new Dictionary(cfg);
            singleton.loadMainDict();
            singleton.loadSurnameDict();
            singleton.loadQuantifierDict();
            singleton.loadSuffixDict();
            singleton.loadPrepDict();
            singleton.loadStopWordDict();
            if (!cfg.isEnableRemoteDict()) return singleton;
            for (String location : singleton.getRemoteExtDictionarys()) {
                pool.scheduleAtFixedRate(new Monitor(location), 10L, 60L, TimeUnit.SECONDS);
            }
            for (String location : singleton.getRemoteExtStopWordDictionarys()) {
                pool.scheduleAtFixedRate(new Monitor(location), 10L, 60L, TimeUnit.SECONDS);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public List<String> getExtDictionarys() {
        ArrayList<String> extDictFiles = new ArrayList<String>(2);
        String extDictCfg = this.getProperty(EXT_DICT);
        if (extDictCfg != null) {
            String[] filePaths;
            for (String filePath : filePaths = extDictCfg.split(";")) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                Path file = PathUtils.get((String)filePath.trim(), (String[])new String[0]);
                extDictFiles.add(file.toString());
            }
        }
        return extDictFiles;
    }

    public List<String> getRemoteExtDictionarys() {
        ArrayList<String> remoteExtDictFiles = new ArrayList<String>(2);
        String remoteExtDictCfg = this.getProperty(REMOTE_EXT_DICT);
        if (remoteExtDictCfg != null) {
            String[] filePaths;
            for (String filePath : filePaths = remoteExtDictCfg.split(";")) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                remoteExtDictFiles.add(filePath);
            }
        }
        return remoteExtDictFiles;
    }

    public List<String> getExtStopWordDictionarys() {
        ArrayList<String> extStopWordDictFiles = new ArrayList<String>(2);
        String extStopWordDictCfg = this.getProperty(EXT_STOP);
        if (extStopWordDictCfg != null) {
            String[] filePaths;
            for (String filePath : filePaths = extStopWordDictCfg.split(";")) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                Path file = PathUtils.get((String)filePath.trim(), (String[])new String[0]);
                extStopWordDictFiles.add(file.toString());
            }
        }
        return extStopWordDictFiles;
    }

    public List<String> getRemoteExtStopWordDictionarys() {
        ArrayList<String> remoteExtStopWordDictFiles = new ArrayList<String>(2);
        String remoteExtStopWordDictCfg = this.getProperty(REMOTE_EXT_STOP);
        if (remoteExtStopWordDictCfg != null) {
            String[] filePaths;
            for (String filePath : filePaths = remoteExtStopWordDictCfg.split(";")) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                remoteExtStopWordDictFiles.add(filePath);
            }
        }
        return remoteExtStopWordDictFiles;
    }

    public String getDictRoot() {
        return this.conf_dir.toAbsolutePath().toString();
    }

    public static Dictionary getSingleton() {
        if (singleton == null) {
            throw new IllegalStateException("\u8bcd\u5178\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528initial\u65b9\u6cd5");
        }
        return singleton;
    }

    public void addWords(Collection<String> words) {
        if (words != null) {
            for (String word : words) {
                if (word == null) continue;
                Dictionary.singleton._MainDict.fillSegment(word.trim().toCharArray());
            }
        }
    }

    public void disableWords(Collection<String> words) {
        if (words != null) {
            for (String word : words) {
                if (word == null) continue;
                Dictionary.singleton._MainDict.disableSegment(word.trim().toCharArray());
            }
        }
    }

    public Hit matchInMainDict(char[] charArray) {
        return Dictionary.singleton._MainDict.match(charArray);
    }

    public Hit matchInMainDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._MainDict.match(charArray, begin, length);
    }

    public Hit matchInQuantifierDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._QuantifierDict.match(charArray, begin, length);
    }

    public Hit matchWithHit(char[] charArray, int currentIndex, Hit matchedHit) {
        DictSegment ds = matchedHit.getMatchedDictSegment();
        return ds.match(charArray, currentIndex, 1, matchedHit);
    }

    public boolean isStopWord(char[] charArray, int begin, int length) {
        return Dictionary.singleton._StopWords.match(charArray, begin, length).isMatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMainDict() {
        this._MainDict = new DictSegment(Character.valueOf('\u0000'));
        Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{PATH_DIC_MAIN});
        FileInputStream is = null;
        try {
            is = new FileInputStream(file.toFile());
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"), 512);
            String theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._MainDict.fillSegment(theWord.trim().toCharArray());
            } while (theWord != null);
        }
        catch (IOException e) {
            logger.error("ik-analyzer", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                    is = null;
                }
            }
            catch (IOException e) {
                logger.error("ik-analyzer", (Throwable)e);
            }
        }
        this.loadExtDict();
        this.loadRemoteExtDict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtDict() {
        List<String> extDictFiles = this.getExtDictionarys();
        if (extDictFiles != null) {
            FileInputStream is = null;
            for (String extDictName : extDictFiles) {
                logger.info("[Dict Loading] " + extDictName);
                Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{extDictName});
                try {
                    is = new FileInputStream(file.toFile());
                }
                catch (FileNotFoundException e) {
                    logger.error("ik-analyzer", (Throwable)e);
                }
                if (is == null) continue;
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"), 512);
                    String theWord = null;
                    do {
                        if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                        this._MainDict.fillSegment(theWord.trim().toCharArray());
                    } while (theWord != null);
                }
                catch (IOException e) {
                    logger.error("ik-analyzer", (Throwable)e);
                }
                finally {
                    try {
                        if (is == null) continue;
                        ((InputStream)is).close();
                        is = null;
                    }
                    catch (IOException e) {
                        logger.error("ik-analyzer", (Throwable)e);
                    }
                }
            }
        }
    }

    private void loadRemoteExtDict() {
        List<String> remoteExtDictFiles = this.getRemoteExtDictionarys();
        for (String location : remoteExtDictFiles) {
            logger.info("[Dict Loading] " + location);
            List<String> lists = Dictionary.getRemoteWords(location);
            if (lists == null) {
                logger.error("[Dict Loading] " + location + "\u52a0\u8f7d\u5931\u8d25");
                continue;
            }
            for (String theWord : lists) {
                if (theWord == null || "".equals(theWord.trim())) continue;
                logger.info(theWord);
                this._MainDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
            }
        }
    }

    private static List<String> getRemoteWords(String location) {
        ArrayList<String> buffer = new ArrayList<String>();
        RequestConfig rc = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(60000).build();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet get = new HttpGet(location);
        get.setConfig(rc);
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                String line;
                String charset = "UTF-8";
                if (response.getEntity().getContentType().getValue().contains("charset=")) {
                    String contentType = response.getEntity().getContentType().getValue();
                    charset = contentType.substring(contentType.lastIndexOf("=") + 1);
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), charset));
                while ((line = in.readLine()) != null) {
                    buffer.add(line);
                }
                in.close();
                response.close();
                return buffer;
            }
            response.close();
        }
        catch (ClientProtocolException e) {
            logger.error("getRemoteWords {} error", new Object[]{e, location});
        }
        catch (IllegalStateException e) {
            logger.error("getRemoteWords {} error", new Object[]{e, location});
        }
        catch (IOException e) {
            logger.error("getRemoteWords {} error", new Object[]{e, location});
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStopWordDict() {
        this._StopWords = new DictSegment(Character.valueOf('\u0000'));
        Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{PATH_DIC_STOP});
        FileInputStream is = null;
        try {
            is = new FileInputStream(file.toFile());
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"), 512);
            Object theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(((String)theWord).trim())) continue;
                this._StopWords.fillSegment(((String)theWord).trim().toCharArray());
            } while (theWord != null);
        }
        catch (IOException e) {
            logger.error("ik-analyzer", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                    is = null;
                }
            }
            catch (IOException e) {
                logger.error("ik-analyzer", (Throwable)e);
            }
        }
        List<String> extStopWordDictFiles = this.getExtStopWordDictionarys();
        if (extStopWordDictFiles != null) {
            is = null;
            for (String extStopWordDictName : extStopWordDictFiles) {
                logger.info("[Dict Loading] " + extStopWordDictName);
                file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{extStopWordDictName});
                try {
                    is = new FileInputStream(file.toFile());
                }
                catch (FileNotFoundException e) {
                    logger.error("ik-analyzer", (Throwable)e);
                }
                if (is == null) continue;
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"), 512);
                    String theWord = null;
                    do {
                        if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                        this._StopWords.fillSegment(theWord.trim().toCharArray());
                    } while (theWord != null);
                }
                catch (IOException e) {
                    logger.error("ik-analyzer", (Throwable)e);
                }
                finally {
                    try {
                        if (is == null) continue;
                        ((InputStream)is).close();
                        is = null;
                    }
                    catch (IOException e) {
                        logger.error("ik-analyzer", (Throwable)e);
                    }
                }
            }
        }
        List<String> remoteExtStopWordDictFiles = this.getRemoteExtStopWordDictionarys();
        for (String location : remoteExtStopWordDictFiles) {
            logger.info("[Dict Loading] " + location);
            List<String> lists = Dictionary.getRemoteWords(location);
            if (lists == null) {
                logger.error("[Dict Loading] " + location + "\u52a0\u8f7d\u5931\u8d25");
                continue;
            }
            for (String theWord : lists) {
                if (theWord == null || "".equals(theWord.trim())) continue;
                logger.info(theWord);
                this._StopWords.fillSegment(theWord.trim().toLowerCase().toCharArray());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQuantifierDict() {
        this._QuantifierDict = new DictSegment(Character.valueOf('\u0000'));
        Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{PATH_DIC_QUANTIFIER});
        FileInputStream is = null;
        try {
            is = new FileInputStream(file.toFile());
        }
        catch (FileNotFoundException e) {
            logger.error("ik-analyzer", (Throwable)e);
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"), 512);
            String theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._QuantifierDict.fillSegment(theWord.trim().toCharArray());
            } while (theWord != null);
        }
        catch (IOException ioe) {
            logger.error("Quantifier Dictionary loading exception.");
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                    is = null;
                }
            }
            catch (IOException e) {
                logger.error("ik-analyzer", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSurnameDict() {
        this._SurnameDict = new DictSegment(Character.valueOf('\u0000'));
        Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{PATH_DIC_SURNAME});
        FileInputStream is = null;
        try {
            is = new FileInputStream(file.toFile());
        }
        catch (FileNotFoundException e) {
            logger.error("ik-analyzer", (Throwable)e);
        }
        if (is == null) {
            throw new RuntimeException("Surname Dictionary not found!!!");
        }
        try {
            String theWord;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"), 512);
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._SurnameDict.fillSegment(theWord.trim().toCharArray());
            } while (theWord != null);
        }
        catch (IOException e) {
            logger.error("ik-analyzer", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                    is = null;
                }
            }
            catch (IOException e) {
                logger.error("ik-analyzer", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSuffixDict() {
        this._SuffixDict = new DictSegment(Character.valueOf('\u0000'));
        Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{PATH_DIC_SUFFIX});
        FileInputStream is = null;
        try {
            is = new FileInputStream(file.toFile());
        }
        catch (FileNotFoundException e) {
            logger.error("ik-analyzer", (Throwable)e);
        }
        if (is == null) {
            throw new RuntimeException("Suffix Dictionary not found!!!");
        }
        try {
            String theWord;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"), 512);
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._SuffixDict.fillSegment(theWord.trim().toCharArray());
            } while (theWord != null);
        }
        catch (IOException e) {
            logger.error("ik-analyzer", (Throwable)e);
        }
        finally {
            try {
                ((InputStream)is).close();
                is = null;
            }
            catch (IOException e) {
                logger.error("ik-analyzer", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrepDict() {
        this._PrepDict = new DictSegment(Character.valueOf('\u0000'));
        Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{PATH_DIC_PREP});
        FileInputStream is = null;
        try {
            is = new FileInputStream(file.toFile());
        }
        catch (FileNotFoundException e) {
            logger.error("ik-analyzer", (Throwable)e);
        }
        if (is == null) {
            throw new RuntimeException("Preposition Dictionary not found!!!");
        }
        try {
            String theWord;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"), 512);
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._PrepDict.fillSegment(theWord.trim().toCharArray());
            } while (theWord != null);
        }
        catch (IOException e) {
            logger.error("ik-analyzer", (Throwable)e);
        }
        finally {
            try {
                ((InputStream)is).close();
                is = null;
            }
            catch (IOException e) {
                logger.error("ik-analyzer", (Throwable)e);
            }
        }
    }

    public void reLoadMainDict() {
        logger.info("\u91cd\u65b0\u52a0\u8f7d\u8bcd\u5178...");
        Dictionary tmpDict = new Dictionary(this.configuration);
        tmpDict.configuration = Dictionary.getSingleton().configuration;
        tmpDict.loadMainDict();
        tmpDict.loadStopWordDict();
        this._MainDict = tmpDict._MainDict;
        this._StopWords = tmpDict._StopWords;
        logger.info("\u91cd\u65b0\u52a0\u8f7d\u8bcd\u5178\u5b8c\u6bd5...");
    }

    static {
        logger = ESLoggerFactory.getLogger((String)Monitor.class.getName());
        pool = Executors.newScheduledThreadPool(1);
    }
}

