/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseBaseFormFilter;
import org.apache.lucene.analysis.ja.JapaneseIterationMarkCharFilter;
import org.apache.lucene.analysis.ja.JapaneseKatakanaStemFilter;
import org.apache.lucene.analysis.ja.JapanesePartOfSpeechStopFilter;
import org.apache.lucene.analysis.ja.JapaneseReadingFormFilter;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;
import org.elasticsearch.indices.analysis.KurumojiCharFilterFactoryFactory;
import org.elasticsearch.indices.analysis.KurumojiTokenFilterFactoryFactory;
import org.elasticsearch.indices.analysis.KurumojiTokenizerFactoryFactory;

public class KuromojiIndicesAnalysis
extends AbstractComponent {
    @Inject
    public KuromojiIndicesAnalysis(Settings settings, IndicesAnalysisService indicesAnalysisService) {
        super(settings);
        indicesAnalysisService.charFilterFactories().put("kuromoji_iteration_mark", new KurumojiCharFilterFactoryFactory(new CharFilterFactory(){

            public String name() {
                return "kuromoji_iteration_mark";
            }

            public Reader create(Reader reader) {
                return new JapaneseIterationMarkCharFilter(reader, true, true);
            }
        }));
        indicesAnalysisService.tokenizerFactories().put("kuromoji_tokenizer", new KurumojiTokenizerFactoryFactory(new TokenizerFactory(){

            public String name() {
                return "kuromoji_tokenizer";
            }

            public Tokenizer create(Reader reader) {
                return new JapaneseTokenizer(reader, null, true, JapaneseTokenizer.Mode.SEARCH);
            }
        }));
        indicesAnalysisService.tokenFilterFactories().put("kuromoji_baseform", new KurumojiTokenFilterFactoryFactory(new TokenFilterFactory(){

            public String name() {
                return "kuromoji_baseform";
            }

            public TokenStream create(TokenStream tokenStream) {
                return new JapaneseBaseFormFilter(tokenStream);
            }
        }));
        indicesAnalysisService.tokenFilterFactories().put("kuromoji_part_of_speech", new KurumojiTokenFilterFactoryFactory(new TokenFilterFactory(){

            public String name() {
                return "kuromoji_part_of_speech";
            }

            public TokenStream create(TokenStream tokenStream) {
                return new JapanesePartOfSpeechStopFilter(Version.LUCENE_44, tokenStream, JapaneseAnalyzer.getDefaultStopTags());
            }
        }));
        indicesAnalysisService.tokenFilterFactories().put("kuromoji_readingform", new KurumojiTokenFilterFactoryFactory(new TokenFilterFactory(){

            public String name() {
                return "kuromoji_readingform";
            }

            public TokenStream create(TokenStream tokenStream) {
                return new JapaneseReadingFormFilter(tokenStream, true);
            }
        }));
        indicesAnalysisService.tokenFilterFactories().put("kuromoji_stemmer", new KurumojiTokenFilterFactoryFactory(new TokenFilterFactory(){

            public String name() {
                return "kuromoji_stemmer";
            }

            public TokenStream create(TokenStream tokenStream) {
                return new JapaneseKatakanaStemFilter(tokenStream);
            }
        }));
    }
}

