/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.kuromoji;

import java.util.Collection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.index.analysis.AnalysisModule;
import org.elasticsearch.index.analysis.KuromojiAnalyzerProvider;
import org.elasticsearch.index.analysis.KuromojiBaseFormFilterFactory;
import org.elasticsearch.index.analysis.KuromojiIterationMarkCharFilterFactory;
import org.elasticsearch.index.analysis.KuromojiKatakanaStemmerFactory;
import org.elasticsearch.index.analysis.KuromojiPartOfSpeechFilterFactory;
import org.elasticsearch.index.analysis.KuromojiReadingFormFilterFactory;
import org.elasticsearch.index.analysis.KuromojiTokenizerFactory;
import org.elasticsearch.indices.analysis.KuromojiIndicesAnalysisModule;
import org.elasticsearch.plugins.AbstractPlugin;

public class AnalysisKuromojiPlugin
extends AbstractPlugin {
    public String name() {
        return "analysis-kuromoji";
    }

    public String description() {
        return "Kuromoji analysis support";
    }

    public Collection<Class<? extends Module>> modules() {
        return ImmutableList.of(KuromojiIndicesAnalysisModule.class);
    }

    public void onModule(AnalysisModule module) {
        module.addCharFilter("kuromoji_iteration_mark", KuromojiIterationMarkCharFilterFactory.class);
        module.addAnalyzer("kuromoji", KuromojiAnalyzerProvider.class);
        module.addTokenizer("kuromoji_tokenizer", KuromojiTokenizerFactory.class);
        module.addTokenFilter("kuromoji_baseform", KuromojiBaseFormFilterFactory.class);
        module.addTokenFilter("kuromoji_part_of_speech", KuromojiPartOfSpeechFilterFactory.class);
        module.addTokenFilter("kuromoji_readingform", KuromojiReadingFormFilterFactory.class);
        module.addTokenFilter("kuromoji_stemmer", KuromojiKatakanaStemmerFactory.class);
    }
}

