/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis;

import org.elasticsearch.common.settings.Settings;

public class PinyinConfig {
    public boolean lowercase = true;
    public boolean trimWhitespace = true;
    public boolean keepNoneChinese = true;
    public boolean keepNoneChineseInFirstLetter = true;
    public boolean keepOriginal = false;
    public boolean keepFirstLetter = true;
    public boolean keepSeparateFirstLetter = false;
    public boolean keepNoneChineseTogether = true;
    public boolean noneChinesePinyinTokenize = true;
    public int LimitFirstLetterLength = 16;
    public boolean keepFullPinyin = true;
    public boolean keepJoinedFullPinyin = false;
    public boolean removeDuplicateTerm = false;

    public PinyinConfig() {
    }

    public PinyinConfig(Settings settings) {
        this.keepFirstLetter = settings.getAsBoolean("keep_first_letter", Boolean.valueOf(true));
        this.keepSeparateFirstLetter = settings.getAsBoolean("keep_separate_first_letter", Boolean.valueOf(false));
        this.keepFullPinyin = settings.getAsBoolean("keep_full_pinyin", Boolean.valueOf(true));
        this.keepJoinedFullPinyin = settings.getAsBoolean("keep_joined_full_pinyin", Boolean.valueOf(false));
        this.keepNoneChinese = settings.getAsBoolean("keep_none_chinese", Boolean.valueOf(true));
        this.keepNoneChineseTogether = settings.getAsBoolean("keep_none_chinese_together", Boolean.valueOf(true));
        this.noneChinesePinyinTokenize = settings.getAsBoolean("none_chinese_pinyin_tokenize", Boolean.valueOf(true));
        this.keepOriginal = settings.getAsBoolean("keep_original", Boolean.valueOf(false));
        this.LimitFirstLetterLength = settings.getAsInt("limit_first_letter_length", Integer.valueOf(16));
        this.lowercase = settings.getAsBoolean("lowercase", Boolean.valueOf(true));
        this.trimWhitespace = settings.getAsBoolean("trim_whitespace", Boolean.valueOf(true));
        this.keepNoneChineseInFirstLetter = settings.getAsBoolean("keep_none_chinese_in_first_letter", Boolean.valueOf(true));
        this.removeDuplicateTerm = settings.getAsBoolean("remove_duplicated_term", Boolean.valueOf(false));
    }
}

