/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.elasticsearch.analysis.PinyinConfig;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.PinyinAnalyzer;
import org.elasticsearch.index.analysis.PinyinTokenFilter;
import org.elasticsearch.index.analysis.PinyinTokenizer;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenFilterFactoryFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenizerFactoryFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;

public class PinyinIndicesAnalysis
extends AbstractComponent {
    @Inject
    public PinyinIndicesAnalysis(Settings settings, IndicesAnalysisService indicesAnalysisService, Environment env) {
        super(settings);
        final PinyinConfig config = new PinyinConfig(settings);
        indicesAnalysisService.analyzerProviderFactories().put("pinyin", new PreBuiltAnalyzerProviderFactory("pinyin", AnalyzerScope.GLOBAL, (Analyzer)new PinyinAnalyzer(config)));
        indicesAnalysisService.tokenizerFactories().put("pinyin", new PreBuiltTokenizerFactoryFactory(new TokenizerFactory(){

            public String name() {
                return "pinyin";
            }

            public Tokenizer create() {
                return new PinyinTokenizer(config);
            }
        }));
        indicesAnalysisService.tokenFilterFactories().put("pinyin", new PreBuiltTokenFilterFactoryFactory(new TokenFilterFactory(){

            public String name() {
                return "pinyin";
            }

            public TokenStream create(TokenStream tokenStream) {
                return new PinyinTokenFilter(tokenStream, config);
            }
        }));
    }
}

