/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

class PinyinAlphabetDict {
    private static final String fileName = "/pinyin_alphabet.dict";
    private Set<String> alphabet = new HashSet<String>();
    private static PinyinAlphabetDict instance;

    private PinyinAlphabetDict() {
        InputStream in = PinyinAlphabetDict.class.getResourceAsStream(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while (null != (line = reader.readLine())) {
                if (line.trim().length() <= 0) continue;
                this.alphabet.add(line);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("read pinyin dic error.", ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PinyinAlphabetDict getInstance() {
        if (instance != null) return instance;
        Class<PinyinAlphabetDict> clazz = PinyinAlphabetDict.class;
        synchronized (PinyinAlphabetDict.class) {
            if (instance != null) return instance;
            instance = new PinyinAlphabetDict();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean match(String c) {
        return this.alphabet.contains(c);
    }
}

