/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.index.analysis.PinyinAlphabetDict;

public class PinyinAlphabetTokenizer {
    public static List<String> walk(String text) {
        int maxLength = 6;
        text = text.toLowerCase();
        LinkedList<String> candidates = new LinkedList<String>();
        StringBuffer buffer = new StringBuffer();
        boolean lastWord = true;
        for (int i = 0; i < text.length(); ++i) {
            String str;
            char c = text.charAt(i);
            if (c > '`' && c < '{' || c > '@' && c < '[') {
                if (!lastWord) {
                    str = buffer.toString();
                    buffer.setLength(0);
                    candidates.add(str);
                }
                buffer.append(c);
                lastWord = true;
            } else {
                if (lastWord) {
                    PinyinAlphabetTokenizer.parse(candidates, buffer);
                    if (buffer.length() > 0) {
                        str = buffer.toString();
                        buffer.setLength(0);
                        candidates.add(str);
                    }
                }
                buffer.append(c);
                lastWord = false;
            }
            if (buffer.length() < maxLength) continue;
            PinyinAlphabetTokenizer.parse(candidates, buffer);
        }
        if (lastWord) {
            PinyinAlphabetTokenizer.parse(candidates, buffer);
        }
        if (buffer.length() > 0) {
            candidates.add(buffer.toString());
        }
        return candidates;
    }

    private static void parse(LinkedList<String> candidates, StringBuffer buffer) {
        for (int j = 0; j < buffer.length(); ++j) {
            String guess = buffer.substring(0, buffer.length() - j);
            if (!PinyinAlphabetDict.getInstance().match(guess)) continue;
            candidates.add(guess);
            String left = buffer.substring(buffer.length() - j, buffer.length());
            buffer.setLength(0);
            buffer.append(left);
            break;
        }
    }
}

