/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.elasticsearch.analysis.PinyinConfig;
import org.elasticsearch.index.analysis.ConfigErrorException;
import org.elasticsearch.index.analysis.PinyinAlphabetTokenizer;
import org.nlpcn.commons.lang.pinyin.Pinyin;

public class PinyinTokenFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private boolean done = true;
    private boolean processedCandidate = false;
    private boolean processedFullPinyinLetter = false;
    private boolean processedFirstLetter = false;
    private boolean processedOriginal = false;
    protected int position = 0;
    protected int lastPosition = 0;
    private PinyinConfig config;
    List<String> candidate;
    StringBuilder firstLetters;
    StringBuilder fullPinyinLetters;
    String source;

    public PinyinTokenFilter(TokenStream in, PinyinConfig config) {
        super(in);
        this.config = config;
        if (!(config.keepFirstLetter || config.keepFullPinyin || config.keepJoinedFullPinyin)) {
            throw new ConfigErrorException("pinyin config error, can't disable first_letter and full_pinyin at the same time.");
        }
        this.candidate = new ArrayList<String>();
        this.firstLetters = new StringBuilder();
        this.fullPinyinLetters = new StringBuilder();
    }

    public final boolean incrementToken() throws IOException {
        if (!this.done && this.readTerm()) {
            return true;
        }
        if (this.done) {
            this.resetVariable();
            if (!this.input.incrementToken()) {
                return false;
            }
            this.done = false;
        }
        this.readTerm();
        return true;
    }

    private boolean readTerm() {
        if (!this.processedCandidate) {
            this.processedCandidate = true;
            int bufferLength = this.termAtt.length();
            this.source = this.termAtt.toString();
            this.lastPosition = bufferLength;
            this.source = this.termAtt.toString();
            if (this.config.trimWhitespace) {
                this.source = this.source.trim();
            }
            List pinyinList = Pinyin.pinyin((String)this.source);
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < this.source.length(); ++i) {
                String pinyin;
                char c = this.source.charAt(i);
                if (c < '\u0080') {
                    if (!(c > '`' && c < '{' || c > '@' && c < '[') && (c <= '/' || c >= ':')) continue;
                    if (this.config.keepNoneChinese) {
                        if (this.config.keepNoneChineseTogether) {
                            buff.append(c);
                        } else {
                            this.candidate.add(String.valueOf(c));
                        }
                    }
                    if (!this.config.keepNoneChineseInFirstLetter) continue;
                    this.firstLetters.append(c);
                    continue;
                }
                if (buff.length() > 0) {
                    this.cleanBuff(buff);
                }
                if ((pinyin = (String)pinyinList.get(i)) == null || pinyin.length() <= 0) continue;
                this.firstLetters.append(pinyin.charAt(0));
                if (this.config.keepSeparateFirstLetter & pinyin.length() > 1) {
                    this.candidate.add(String.valueOf(pinyin.charAt(0)));
                }
                if (this.config.keepFullPinyin) {
                    this.candidate.add(pinyin);
                }
                if (!this.config.keepJoinedFullPinyin) continue;
                this.fullPinyinLetters.append(pinyin);
            }
            if (buff.length() > 0) {
                this.cleanBuff(buff);
            }
        }
        if (this.position < this.candidate.size()) {
            String s = this.candidate.get(this.position);
            if (this.config.lowercase) {
                s = s.toLowerCase();
            }
            this.termAtt.setEmpty();
            this.termAtt.append(s);
            ++this.position;
            return true;
        }
        if (this.config.keepOriginal && !this.processedOriginal) {
            this.processedOriginal = true;
            this.termAtt.setEmpty();
            this.termAtt.append(this.source);
            this.termAtt.setLength(this.source.length());
            return true;
        }
        if (this.config.keepJoinedFullPinyin && !this.processedFullPinyinLetter) {
            this.processedFullPinyinLetter = true;
            this.termAtt.setEmpty();
            this.termAtt.append(this.fullPinyinLetters.toString());
            this.termAtt.setLength(this.fullPinyinLetters.length());
            this.fullPinyinLetters.setLength(0);
            return true;
        }
        if (this.config.keepFirstLetter && this.firstLetters.length() > 0 && !this.processedFirstLetter) {
            this.processedFirstLetter = true;
            String fl = this.firstLetters.length() > this.config.LimitFirstLetterLength && this.config.LimitFirstLetterLength > 0 ? this.firstLetters.substring(0, this.config.LimitFirstLetterLength) : this.firstLetters.toString();
            if (this.config.lowercase) {
                fl = fl.toLowerCase();
            }
            if (!this.config.keepSeparateFirstLetter || fl.length() > 1) {
                this.termAtt.setEmpty();
                this.termAtt.append(fl);
                this.termAtt.setLength(fl.length());
                return true;
            }
        }
        this.done = true;
        return false;
    }

    private void cleanBuff(StringBuilder buff) {
        if (this.config.keepNoneChinese) {
            if (this.config.noneChinesePinyinTokenize) {
                List<String> temp = PinyinAlphabetTokenizer.walk(buff.toString());
                for (int j = 0; j < temp.size(); ++j) {
                    String tmp = temp.get(j);
                    this.candidate.add(tmp);
                }
            } else {
                this.candidate.add(buff.toString());
            }
        }
        buff.setLength(0);
    }

    public final void end() throws IOException {
        super.end();
    }

    void resetVariable() {
        this.position = 0;
        this.lastPosition = 0;
        this.candidate.clear();
        this.processedCandidate = false;
        this.processedFirstLetter = false;
        this.processedFullPinyinLetter = false;
        this.processedOriginal = false;
        this.firstLetters.setLength(0);
        this.fullPinyinLetters.setLength(0);
        this.source = null;
        this.candidate.clear();
    }

    public void reset() throws IOException {
        super.reset();
        this.done = true;
        this.resetVariable();
    }
}

