/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.analysis.PinyinConfig;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.PinyinTokenFilter;
import org.elasticsearch.index.settings.IndexSettingsService;

public class PinyinTokenFilterFactory
extends AbstractTokenFilterFactory {
    private PinyinConfig config;

    @Inject
    public PinyinTokenFilterFactory(Index index, IndexSettingsService indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings.getSettings(), name, settings);
        this.config = new PinyinConfig(settings);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new PinyinTokenFilter(tokenStream, this.config);
    }
}

