/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.elasticsearch.analysis.PinyinConfig;
import org.elasticsearch.index.analysis.ConfigErrorException;
import org.elasticsearch.index.analysis.PinyinAlphabetTokenizer;
import org.elasticsearch.index.analysis.TermItem;
import org.nlpcn.commons.lang.pinyin.Pinyin;

public class PinyinTokenizer
extends Tokenizer {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private boolean done = false;
    private boolean processedCandidate = false;
    private boolean processedFirstLetter = false;
    private boolean processedFullPinyinLetter = false;
    private boolean processedOriginal = false;
    protected int position = 0;
    protected int lastPosition = 0;
    private OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private PinyinConfig config;
    ArrayList<TermItem> candidate;
    private HashSet<String> termsFilter;
    StringBuilder firstLetters;
    StringBuilder fullPinyinLetters;
    String source;

    public PinyinTokenizer(PinyinConfig config) {
        this(256);
        this.config = config;
        if (!(config.keepFirstLetter || config.keepFullPinyin || config.keepJoinedFullPinyin)) {
            throw new ConfigErrorException("pinyin config error, can't disable first_letter and full_pinyin at the same time.");
        }
        this.candidate = new ArrayList();
        this.termsFilter = new HashSet();
        this.firstLetters = new StringBuilder();
        this.fullPinyinLetters = new StringBuilder();
    }

    public PinyinTokenizer(int bufferSize) {
        this.termAtt.resizeBuffer(bufferSize);
    }

    void addCandidate(TermItem item) {
        String term = item.term;
        if (this.config.lowercase) {
            term = term.toLowerCase();
        }
        if (this.config.trimWhitespace) {
            term = term.trim();
        }
        item.term = term;
        if (this.config.removeDuplicateTerm) {
            if (this.termsFilter.contains(term)) {
                return;
            }
            this.termsFilter.add(term);
        }
        this.candidate.add(item);
    }

    void setTerm(String term, int startOffset, int endOffset) {
        if (this.config.lowercase) {
            term = term.toLowerCase();
        }
        if (this.config.trimWhitespace) {
            term = term.trim();
        }
        this.termAtt.setEmpty();
        this.termAtt.append(term);
        if (startOffset < 0) {
            startOffset = 0;
        }
        if (endOffset < startOffset) {
            endOffset = startOffset + term.length();
        }
        this.offsetAtt.setOffset(this.correctOffset(startOffset), this.correctOffset(endOffset));
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (!this.done) {
            if (!this.processedCandidate) {
                int length;
                this.processedCandidate = true;
                int upto = 0;
                char[] buffer = this.termAtt.buffer();
                while ((length = this.input.read(buffer, upto, buffer.length - upto)) != -1) {
                    if ((upto += length) != buffer.length) continue;
                    buffer = this.termAtt.resizeBuffer(1 + buffer.length);
                }
                this.termAtt.setLength(upto);
                this.source = this.termAtt.toString();
                List pinyinList = Pinyin.pinyin((String)this.source);
                StringBuilder buff = new StringBuilder();
                int buffSize = 0;
                for (int i = 0; i < this.source.length(); ++i) {
                    String pinyin;
                    char c = this.source.charAt(i);
                    this.lastPosition = i;
                    if (c < '\u0080') {
                        if (!(c > '`' && c < '{' || c > '@' && c < '[') && (c <= '/' || c >= ':')) continue;
                        if (this.config.keepNoneChinese && this.config.keepNoneChinese) {
                            if (this.config.keepNoneChineseTogether) {
                                buff.append(c);
                                ++buffSize;
                            } else {
                                this.addCandidate(new TermItem(String.valueOf(c), i, i + 1));
                            }
                        }
                        if (!this.config.keepNoneChineseInFirstLetter) continue;
                        this.firstLetters.append(c);
                        continue;
                    }
                    if (buff.length() > 0) {
                        this.parseBuff(buff, buffSize);
                        buffSize = 0;
                    }
                    if ((pinyin = (String)pinyinList.get(i)) == null || pinyin.length() <= 0) continue;
                    this.firstLetters.append(pinyin.charAt(0));
                    if (this.config.keepSeparateFirstLetter & pinyin.length() > 1) {
                        this.addCandidate(new TermItem(String.valueOf(pinyin.charAt(0)), i, i + 1));
                    }
                    if (this.config.keepFullPinyin) {
                        this.addCandidate(new TermItem(pinyin, i, i + 1));
                    }
                    if (!this.config.keepJoinedFullPinyin) continue;
                    this.fullPinyinLetters.append(pinyin);
                }
                if (buff.length() > 0) {
                    this.parseBuff(buff, buffSize);
                }
            }
            if (this.config.keepOriginal && !this.processedOriginal) {
                this.processedOriginal = true;
                this.addCandidate(new TermItem(this.source, 0, this.source.length()));
            }
            if (this.config.keepJoinedFullPinyin && !this.processedFullPinyinLetter) {
                this.processedFullPinyinLetter = true;
                this.addCandidate(new TermItem(this.fullPinyinLetters.toString(), 0, this.fullPinyinLetters.length()));
                this.fullPinyinLetters.setLength(0);
            }
            if (this.config.keepFirstLetter && this.firstLetters.length() > 0 && !this.processedFirstLetter) {
                this.processedFirstLetter = true;
                String fl = this.firstLetters.length() > this.config.LimitFirstLetterLength && this.config.LimitFirstLetterLength > 0 ? this.firstLetters.substring(0, this.config.LimitFirstLetterLength) : this.firstLetters.toString();
                if (this.config.lowercase) {
                    fl = fl.toLowerCase();
                }
                if (!this.config.keepSeparateFirstLetter || fl.length() > 1) {
                    this.addCandidate(new TermItem(fl, 0, fl.length()));
                }
            }
            if (this.position < this.candidate.size()) {
                TermItem item = this.candidate.get(this.position);
                ++this.position;
                this.setTerm(item.term, item.startOffset, item.endOffset);
                return true;
            }
            this.done = true;
            return false;
        }
        return false;
    }

    private void parseBuff(StringBuilder buff, int buffSize) {
        if (this.config.keepNoneChinese) {
            if (this.config.noneChinesePinyinTokenize) {
                List<String> result = PinyinAlphabetTokenizer.walk(buff.toString());
                for (int i = 0; i < result.size(); ++i) {
                    this.addCandidate(new TermItem(result.get(i), this.lastPosition - buffSize, this.lastPosition));
                }
            } else {
                this.addCandidate(new TermItem(buff.toString(), this.lastPosition - buffSize, this.lastPosition));
            }
        }
        buff.setLength(0);
    }

    public final void end() throws IOException {
        super.end();
    }

    public void reset() throws IOException {
        super.reset();
        this.position = 0;
        this.done = false;
        this.processedCandidate = false;
        this.processedFirstLetter = false;
        this.processedFullPinyinLetter = false;
        this.processedOriginal = false;
        this.firstLetters.setLength(0);
        this.fullPinyinLetters.setLength(0);
        this.termsFilter.clear();
        this.candidate.clear();
        this.source = null;
    }
}

