/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cloud.aws.AwsSettingsFilter;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;

public class AwsS3Service
extends AbstractLifecycleComponent<AwsS3Service> {
    private AmazonS3Client client;

    @Inject
    public AwsS3Service(Settings settings, SettingsFilter settingsFilter) {
        super(settings);
        settingsFilter.addFilter((SettingsFilter.Filter)new AwsSettingsFilter());
    }

    public synchronized AmazonS3 client() {
        if (this.client != null) {
            return this.client;
        }
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        String protocol = this.componentSettings.get("protocol", "http").toLowerCase();
        if ("http".equals(protocol)) {
            clientConfiguration.setProtocol(Protocol.HTTP);
        } else if ("https".equals(protocol)) {
            clientConfiguration.setProtocol(Protocol.HTTPS);
        } else {
            throw new ElasticSearchIllegalArgumentException("No protocol supported [" + protocol + "], can either be [http] or [https]");
        }
        String account = this.componentSettings.get("access_key", this.settings.get("cloud.account"));
        String key = this.componentSettings.get("secret_key", this.settings.get("cloud.key"));
        if (account == null) {
            throw new ElasticSearchIllegalArgumentException("No s3 access_key defined for s3 gateway");
        }
        if (key == null) {
            throw new ElasticSearchIllegalArgumentException("No s3 secret_key defined for s3 gateway");
        }
        this.client = new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(account, key), clientConfiguration);
        if (this.componentSettings.get("s3.endpoint") != null) {
            this.client.setEndpoint(this.componentSettings.get("s3.endpoint"));
        } else if (this.componentSettings.get("region") != null) {
            String endpoint;
            String region = this.componentSettings.get("region");
            if ("us-east".equals(region.toLowerCase())) {
                endpoint = "s3.amazonaws.com";
            } else if ("us-east-1".equals(region.toLowerCase())) {
                endpoint = "s3.amazonaws.com";
            } else if ("us-west".equals(region.toLowerCase())) {
                endpoint = "s3-us-west-1.amazonaws.com";
            } else if ("us-west-1".equals(region.toLowerCase())) {
                endpoint = "s3-us-west-1.amazonaws.com";
            } else if ("ap-southeast".equals(region.toLowerCase())) {
                endpoint = "s3-ap-southeast-1.amazonaws.com";
            } else if ("ap-southeast-1".equals(region.toLowerCase())) {
                endpoint = "s3-ap-southeast-1.amazonaws.com";
            } else if ("eu-west".equals(region.toLowerCase())) {
                endpoint = null;
            } else if ("eu-west-1".equals(region.toLowerCase())) {
                endpoint = null;
            } else {
                throw new ElasticSearchIllegalArgumentException("No automatic endpoint could be derived from region [" + region + "]");
            }
            this.client.setEndpoint(endpoint);
        }
        return this.client;
    }

    protected void doStart() throws ElasticSearchException {
    }

    protected void doStop() throws ElasticSearchException {
    }

    protected void doClose() throws ElasticSearchException {
        if (this.client != null) {
            this.client.shutdown();
        }
    }
}

