/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws.blobstore;

import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.elasticsearch.cloud.aws.blobstore.S3BlobStore;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.PlainBlobMetaData;
import org.elasticsearch.common.collect.ImmutableMap;

public class AbstractS3BlobContainer
extends AbstractBlobContainer {
    protected final S3BlobStore blobStore;
    protected final String keyPath;

    public AbstractS3BlobContainer(BlobPath path, S3BlobStore blobStore) {
        super(path);
        this.blobStore = blobStore;
        this.keyPath = path.buildAsString("/") + "/";
    }

    public boolean blobExists(String blobName) {
        try {
            this.blobStore.client().getObjectMetadata(this.blobStore.bucket(), this.buildKey(blobName));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean deleteBlob(String blobName) throws IOException {
        this.blobStore.client().deleteObject(this.blobStore.bucket(), this.buildKey(blobName));
        return true;
    }

    public void readBlob(final String blobName, final BlobContainer.ReadBlobListener listener) {
        this.blobStore.executor().execute(new Runnable(){

            @Override
            public void run() {
                InputStream is;
                try {
                    S3Object object = AbstractS3BlobContainer.this.blobStore.client().getObject(AbstractS3BlobContainer.this.blobStore.bucket(), AbstractS3BlobContainer.this.buildKey(blobName));
                    is = object.getObjectContent();
                }
                catch (Exception e) {
                    listener.onFailure((Throwable)e);
                    return;
                }
                byte[] buffer = new byte[AbstractS3BlobContainer.this.blobStore.bufferSizeInBytes()];
                try {
                    int bytesRead;
                    while ((bytesRead = is.read(buffer)) != -1) {
                        listener.onPartial(buffer, 0, bytesRead);
                    }
                    listener.onCompleted();
                }
                catch (Exception e) {
                    try {
                        is.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    listener.onFailure((Throwable)e);
                }
            }
        });
    }

    public ImmutableMap<String, BlobMetaData> listBlobsByPrefix(@Nullable String blobNamePrefix) throws IOException {
        ImmutableMap.Builder blobsBuilder = ImmutableMap.builder();
        ObjectListing prevListing = null;
        while (true) {
            ObjectListing list = prevListing != null ? this.blobStore.client().listNextBatchOfObjects(prevListing) : (blobNamePrefix != null ? this.blobStore.client().listObjects(this.blobStore.bucket(), this.buildKey(blobNamePrefix)) : this.blobStore.client().listObjects(this.blobStore.bucket(), this.keyPath));
            for (S3ObjectSummary summary : list.getObjectSummaries()) {
                String name = summary.getKey().substring(this.keyPath.length());
                blobsBuilder.put((Object)name, (Object)new PlainBlobMetaData(name, summary.getSize()));
            }
            if (!list.isTruncated()) break;
            prevListing = list;
        }
        return blobsBuilder.build();
    }

    public ImmutableMap<String, BlobMetaData> listBlobs() throws IOException {
        return this.listBlobsByPrefix(null);
    }

    protected String buildKey(String blobName) {
        return this.keyPath + blobName;
    }
}

