/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws.blobstore;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.elasticsearch.cloud.aws.blobstore.S3ImmutableBlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.ImmutableBlobContainer;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;

public class S3BlobStore
extends AbstractComponent
implements BlobStore {
    private final AmazonS3 client;
    private final String bucket;
    private final String region;
    private final Executor executor;
    private final int bufferSizeInBytes;

    public S3BlobStore(Settings settings, AmazonS3 client, String bucket, @Nullable String region, Executor executor) {
        super(settings);
        this.client = client;
        this.bucket = bucket;
        this.region = region;
        this.executor = executor;
        this.bufferSizeInBytes = (int)settings.getAsBytesSize("buffer_size", new ByteSizeValue(100L, ByteSizeUnit.KB)).bytes();
        if (!client.doesBucketExist(bucket)) {
            if (region != null) {
                client.createBucket(bucket, region);
            } else {
                client.createBucket(bucket);
            }
        }
    }

    public String toString() {
        return (this.region == null ? "" : this.region + "/") + this.bucket;
    }

    public AmazonS3 client() {
        return this.client;
    }

    public String bucket() {
        return this.bucket;
    }

    public Executor executor() {
        return this.executor;
    }

    public int bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    public ImmutableBlobContainer immutableBlobContainer(BlobPath path) {
        return new S3ImmutableBlobContainer(path, this);
    }

    public void delete(BlobPath path) {
        ObjectListing prevListing = null;
        while (true) {
            ObjectListing list = prevListing != null ? this.client.listNextBatchOfObjects(prevListing) : this.client.listObjects(this.bucket, path.buildAsString("/"));
            for (S3ObjectSummary summary : list.getObjectSummaries()) {
                this.client.deleteObject(summary.getBucketName(), summary.getKey());
            }
            if (!list.isTruncated()) break;
            prevListing = list;
        }
    }

    public void close() {
    }
}

