/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws.blobstore;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.cloud.aws.blobstore.AbstractS3BlobContainer;
import org.elasticsearch.cloud.aws.blobstore.S3BlobStore;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.ImmutableBlobContainer;
import org.elasticsearch.common.blobstore.support.BlobStores;

public class S3ImmutableBlobContainer
extends AbstractS3BlobContainer
implements ImmutableBlobContainer {
    public S3ImmutableBlobContainer(BlobPath path, S3BlobStore blobStore) {
        super(path, blobStore);
    }

    public void writeBlob(final String blobName, final InputStream is, final long sizeInBytes, final ImmutableBlobContainer.WriterListener listener) {
        this.blobStore.executor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ObjectMetadata md = new ObjectMetadata();
                    md.setContentLength(sizeInBytes);
                    PutObjectResult objectResult = S3ImmutableBlobContainer.this.blobStore.client().putObject(S3ImmutableBlobContainer.this.blobStore.bucket(), S3ImmutableBlobContainer.this.buildKey(blobName), is, md);
                    listener.onCompleted();
                }
                catch (Exception e) {
                    listener.onFailure((Throwable)e);
                }
            }
        });
    }

    public void writeBlob(String blobName, InputStream is, long sizeInBytes) throws IOException {
        BlobStores.syncWriteBlob((ImmutableBlobContainer)this, (String)blobName, (InputStream)is, (long)sizeInBytes);
    }
}

