/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;

public class AwsEc2UnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    private final AmazonEC2 client;
    private final String ports;
    private final boolean bindAnyGroup;
    private final ImmutableSet<String> groups;
    private final ImmutableMap<String, String> tags;
    private final ImmutableSet<String> availabilityZones;
    private final HostType hostType;

    @Inject
    public AwsEc2UnicastHostsProvider(Settings settings, AmazonEC2 client) {
        super(settings);
        this.client = client;
        this.hostType = HostType.valueOf(this.componentSettings.get("host_type", "private_ip").toUpperCase());
        this.ports = this.componentSettings.get("ports", "9300-9302");
        this.bindAnyGroup = this.componentSettings.getAsBoolean("any_group", Boolean.valueOf(true));
        this.groups = ImmutableSet.copyOf((Object[])this.componentSettings.getAsArray("groups"));
        this.tags = this.componentSettings.getByPrefix("tag.").getAsMap();
        HashSet availabilityZones = Sets.newHashSet((Object[])this.componentSettings.getAsArray("availability_zones"));
        if (this.componentSettings.get("availability_zones") != null) {
            availabilityZones.addAll(Strings.commaDelimitedListToSet((String)this.componentSettings.get("availability_zones")));
        }
        this.availabilityZones = ImmutableSet.copyOf((Collection)availabilityZones);
    }

    public List<DiscoveryNode> buildDynamicNodes() {
        ArrayList discoNodes = Lists.newArrayList();
        DescribeInstancesResult descInstances = this.client.describeInstances(new DescribeInstancesRequest());
        this.logger.trace("building dynamic unicast discovery nodes...", new Object[0]);
        for (Reservation reservation : descInstances.getReservations()) {
            if (!this.groups.isEmpty()) {
                List groupNames = reservation.getGroupNames();
                if (this.bindAnyGroup) {
                    if (Collections.disjoint(this.groups, groupNames)) {
                        this.logger.trace("filtering out reservation {} based on groups {}, not part of {}", new Object[]{reservation.getReservationId(), groupNames, this.groups});
                        continue;
                    }
                } else if (!groupNames.containsAll((Collection<?>)this.groups)) {
                    this.logger.trace("filtering out reservation {} based on groups {}, does not include all of {}", new Object[]{reservation.getReservationId(), groupNames, this.groups});
                    continue;
                }
            }
            for (Instance instance : reservation.getInstances()) {
                if (!this.availabilityZones.isEmpty() && !this.availabilityZones.contains((Object)instance.getPlacement().getAvailabilityZone())) {
                    this.logger.trace("filtering out instance {} based on availability_zone {}, not part of {}", new Object[]{instance.getInstanceId(), instance.getPlacement().getAvailabilityZone(), this.availabilityZones});
                    continue;
                }
                boolean filterByTag = false;
                if (!this.tags.isEmpty()) {
                    if (instance.getTags() == null) {
                        filterByTag = true;
                    } else {
                        for (Map.Entry entry : this.tags.entrySet()) {
                            boolean found = false;
                            for (Tag tag : instance.getTags()) {
                                if (!((String)entry.getKey()).equals(tag.getKey()) || !((String)entry.getValue()).equals(tag.getValue())) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            filterByTag = true;
                            break;
                        }
                    }
                }
                if (filterByTag) {
                    this.logger.trace("filtering out instance {} based tags {}, not part of {}", new Object[]{instance.getInstanceId(), this.tags, instance.getTags()});
                    continue;
                }
                InstanceState state = instance.getState();
                if (!state.getName().equalsIgnoreCase("pending") && !state.getName().equalsIgnoreCase("running")) continue;
                String address = null;
                switch (this.hostType) {
                    case PRIVATE_DNS: {
                        address = instance.getPrivateDnsName();
                        break;
                    }
                    case PRIVATE_IP: {
                        address = instance.getPrivateIpAddress();
                        break;
                    }
                    case PUBLIC_DNS: {
                        address = instance.getPublicDnsName();
                        break;
                    }
                    case PUBLIC_IP: {
                        address = instance.getPublicDnsName();
                    }
                }
                for (int port : new PortsRange(this.ports).ports()) {
                    if (address != null) {
                        this.logger.trace("adding {}, address {}", new Object[]{instance.getInstanceId(), address});
                        discoNodes.add(new DiscoveryNode("#cloud-" + instance.getInstanceId() + "-" + port, (TransportAddress)new InetSocketTransportAddress(address, port)));
                        continue;
                    }
                    this.logger.trace("not adding {}, address is null, host_type {}", new Object[]{instance.getInstanceId(), this.hostType});
                }
            }
        }
        this.logger.debug("using dynamic discovery nodes {}", new Object[]{discoNodes});
        return discoNodes;
    }

    private static enum HostType {
        PRIVATE_IP,
        PUBLIC_IP,
        PRIVATE_DNS,
        PUBLIC_DNS;

    }
}

