/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import org.elasticsearch.cloud.aws.AwsEc2Service;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.ec2.AwsEc2UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.ZenPingService;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastZenPing;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class Ec2Discovery
extends ZenDiscovery {
    @Inject
    public Ec2Discovery(Settings settings, ClusterName clusterName, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ZenPingService pingService, AwsEc2Service ec2Service) {
        super(settings, clusterName, threadPool, transportService, clusterService, pingService);
        if (settings.getAsBoolean("cloud.enabled", Boolean.valueOf(true)).booleanValue()) {
            ImmutableList zenPings = pingService.zenPings();
            UnicastZenPing unicastZenPing = null;
            for (ZenPing zenPing : zenPings) {
                if (!(zenPing instanceof UnicastZenPing)) continue;
                unicastZenPing = (UnicastZenPing)zenPing;
                break;
            }
            unicastZenPing.addHostsProvider((UnicastHostsProvider)new AwsEc2UnicastHostsProvider(settings, ec2Service.client()));
            pingService.zenPings(ImmutableList.of((Object)unicastZenPing));
        }
    }
}

