/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.s3;

import java.io.IOException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cloud.aws.AwsS3Service;
import org.elasticsearch.cloud.aws.blobstore.S3BlobStore;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.gateway.blobstore.BlobStoreGateway;
import org.elasticsearch.index.gateway.s3.S3IndexGatewayModule;
import org.elasticsearch.threadpool.ThreadPool;

public class S3Gateway
extends BlobStoreGateway {
    @Inject
    public S3Gateway(Settings settings, ClusterService clusterService, MetaDataCreateIndexService createIndexService, ClusterName clusterName, ThreadPool threadPool, AwsS3Service s3Service) throws IOException {
        super(settings, clusterService, createIndexService);
        String bucket = this.componentSettings.get("bucket");
        if (bucket == null) {
            throw new ElasticSearchIllegalArgumentException("No bucket defined for s3 gateway");
        }
        String region = this.componentSettings.get("region");
        if (region == null && settings.get("cloud.aws.region") != null) {
            String regionSetting = settings.get("cloud.aws.region");
            if ("us-east".equals(regionSetting.toLowerCase())) {
                region = null;
            } else if ("us-east-1".equals(regionSetting.toLowerCase())) {
                region = null;
            } else if ("us-west".equals(regionSetting.toLowerCase())) {
                region = "us-west-1";
            } else if ("us-west-1".equals(regionSetting.toLowerCase())) {
                region = "us-west-1";
            } else if ("ap-southeast".equals(regionSetting.toLowerCase())) {
                region = "ap-southeast-1";
            } else if ("ap-southeast-1".equals(regionSetting.toLowerCase())) {
                region = "ap-southeast-1";
            } else if ("eu-west".equals(regionSetting.toLowerCase())) {
                region = "EU";
            } else if ("eu-west-1".equals(regionSetting.toLowerCase())) {
                region = "EU";
            }
        }
        ByteSizeValue chunkSize = this.componentSettings.getAsBytesSize("chunk_size", new ByteSizeValue(100L, ByteSizeUnit.MB));
        this.logger.debug("using bucket [{}], region [{}], chunk_size [{}]", new Object[]{bucket, region, chunkSize});
        this.initialize(new S3BlobStore(settings, s3Service.client(), bucket, region, threadPool.cached()), clusterName, chunkSize);
    }

    public void close() throws ElasticSearchException {
        super.close();
    }

    public String type() {
        return "s3";
    }

    public Class<? extends Module> suggestIndexGateway() {
        return S3IndexGatewayModule.class;
    }
}

