/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.cloud.aws;

import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.cloud.aws.AwsEc2Service;
import org.elasticsearch.cloud.aws.AwsModule;
import org.elasticsearch.cloud.aws.AwsS3Service;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.AbstractPlugin;

public class CloudAwsPlugin
extends AbstractPlugin {
    private final Settings settings;

    public CloudAwsPlugin(Settings settings) {
        this.settings = settings;
    }

    public String name() {
        return "cloud-aws";
    }

    public String description() {
        return "Cloud AWS Plugin";
    }

    public Collection<Class<? extends Module>> modules() {
        ArrayList modules = Lists.newArrayList();
        if (this.settings.getAsBoolean("cloud.enabled", Boolean.valueOf(true)).booleanValue()) {
            modules.add(AwsModule.class);
        }
        return modules;
    }

    public Collection<Class<? extends LifecycleComponent>> services() {
        ArrayList services = Lists.newArrayList();
        if (this.settings.getAsBoolean("cloud.enabled", Boolean.valueOf(true)).booleanValue()) {
            services.add(AwsS3Service.class);
            services.add(AwsEc2Service.class);
        }
        return services;
    }
}

