/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import java.util.EnumMap;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;

public abstract class PerEntityPoolingMetadataExtractor
implements MetadataExtractor {
    protected Object entity;
    private final EnumMap<MetadataExtractor.Metadata, StaticFieldExtractor> pool = new EnumMap(MetadataExtractor.Metadata.class);

    public void reset() {
        this.entity = null;
    }

    @Override
    public FieldExtractor get(MetadataExtractor.Metadata metadata) {
        StaticFieldExtractor fieldExtractor = this.pool.get((Object)metadata);
        if (fieldExtractor == null || fieldExtractor.needsInit()) {
            Object value = this.getValue(metadata);
            if (value == null) {
                return null;
            }
            if (fieldExtractor == null) {
                fieldExtractor = new StaticFieldExtractor();
            }
            if (fieldExtractor.needsInit()) {
                fieldExtractor.setField(value);
            }
            this.pool.put(metadata, fieldExtractor);
        }
        return fieldExtractor;
    }

    public abstract Object getValue(MetadataExtractor.Metadata var1);

    public void setObject(Object entity) {
        this.entity = entity;
    }

    private static class StaticFieldExtractor
    implements FieldExtractor {
        private Object field;
        private boolean needsInit = true;

        private StaticFieldExtractor() {
        }

        @Override
        public Object field(Object target) {
            return this.field;
        }

        public void setField(Object field) {
            this.field = field;
            this.needsInit = true;
        }

        public boolean needsInit() {
            return this.needsInit;
        }
    }
}

