/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.commonshttp;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.protocol.Protocol;

class ProtocolAwareHostConfiguration
extends HostConfiguration {
    public ProtocolAwareHostConfiguration(HostConfiguration hostConfiguration) {
        super(hostConfiguration);
    }

    public Object clone() {
        return new ProtocolAwareHostConfiguration(this);
    }

    public synchronized void setHost(String host, int port, String scheme) {
        this.setHost(new HttpHost(host, port, this.keepProtocol(host, port, scheme)));
    }

    protected Protocol keepProtocol(String host, int port, String scheme) {
        String oldScheme;
        Protocol oldProtocol = this.getProtocol();
        if (oldProtocol != null && ((oldScheme = oldProtocol.getScheme()) == scheme || oldScheme != null && oldScheme.equalsIgnoreCase(scheme))) {
            return oldProtocol;
        }
        return Protocol.getProtocol((String)scheme);
    }
}

