/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.UDFContext;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.HadoopSettingsManager;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.EsOutputFormat;
import org.elasticsearch.hadoop.mr.security.HadoopUserProvider;
import org.elasticsearch.hadoop.mr.security.TokenUtil;
import org.elasticsearch.hadoop.pig.EsPigInputFormat;
import org.elasticsearch.hadoop.pig.PigBytesConverter;
import org.elasticsearch.hadoop.pig.PigFieldExtractor;
import org.elasticsearch.hadoop.pig.PigTuple;
import org.elasticsearch.hadoop.pig.PigUtils;
import org.elasticsearch.hadoop.pig.PigValueReader;
import org.elasticsearch.hadoop.pig.PigValueWriter;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class EsStorage
extends LoadFunc
implements LoadMetadata,
LoadPushDown,
StoreFuncInterface,
StoreMetadata {
    private static final Log log = LogFactory.getLog(EsStorage.class);
    private final boolean trace = log.isTraceEnabled();
    private static final String CREDENTIALS_ADDED = "es.pig.credentials.added";
    private Properties properties = new Properties();
    private String relativeLocation;
    private String signature;
    private ResourceSchema schema;
    private RecordReader<String, Map<?, ?>> reader;
    private RecordWriter<Object, Object> writer;
    private PigTuple pigTuple;
    private boolean isJSON = false;
    private List<String> aliasesTupleNames;

    public EsStorage() {
        this(new String[0]);
    }

    public EsStorage(String ... configuration) {
        if (!ObjectUtils.isEmpty(configuration)) {
            try {
                for (String string : configuration) {
                    this.properties.load(new StringReader(string));
                    log.trace((Object)this.properties.toString());
                }
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalArgumentException("Cannot parse options " + Arrays.toString(configuration), ex);
            }
        }
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return location;
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.signature = signature;
    }

    private Properties getUDFProperties() {
        return UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        Properties props = this.getUDFProperties();
        if (!StringUtils.hasText(props.getProperty(ResourceSchema.class.getName()))) {
            props.setProperty(ResourceSchema.class.getName(), IOUtils.serializeToBase64((Serializable)s));
        }
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        this.init(location, job, false);
        Configuration cfg = job.getConfiguration();
        Settings settings = HadoopSettingsManager.loadFrom(cfg);
        this.addEsApiKeyToken(settings, job);
    }

    private void init(String location, Job job, boolean read) {
        Settings settings = HadoopSettingsManager.loadFrom(job.getConfiguration()).merge(this.properties);
        settings = read ? settings.setResourceRead(location) : settings.setResourceWrite(location);
        InitializationUtils.checkIdForOperation(settings);
        InitializationUtils.setValueWriterIfNotSet(settings, PigValueWriter.class, log);
        InitializationUtils.setValueReaderIfNotSet(settings, PigValueReader.class, log);
        InitializationUtils.setBytesConverterIfNeeded(settings, PigBytesConverter.class, log);
        InitializationUtils.setFieldExtractorIfNotSet(settings, PigFieldExtractor.class, log);
        InitializationUtils.setUserProviderIfNotSet(settings, HadoopUserProvider.class, log);
        InitializationUtils.discoverClusterInfo(settings, log);
        this.isJSON = settings.getOutputAsJson();
    }

    public OutputFormat<Object, Map<Writable, Writable>> getOutputFormat() throws IOException {
        return new EsOutputFormat();
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
        Properties props = this.getUDFProperties();
        String s = props.getProperty(ResourceSchema.class.getName());
        if (!StringUtils.hasText(s)) {
            log.warn((Object)"No resource schema found; using an empty one....");
            this.schema = new ResourceSchema();
        } else {
            this.schema = (ResourceSchema)IOUtils.deserializeFromBase64(s);
        }
        this.pigTuple = new PigTuple(this.schema);
    }

    public void putNext(Tuple t) throws IOException {
        this.pigTuple.setTuple(t);
        if (this.trace) {
            log.trace((Object)("Writing out tuple " + t));
        }
        try {
            this.writer.write(null, (Object)this.pigTuple);
        }
        catch (InterruptedException ex) {
            throw new EsHadoopIllegalArgumentException("interrupted", ex);
        }
    }

    public void cleanupOnFailure(String location, Job job) throws IOException {
    }

    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    public void storeStatistics(ResourceStatistics stats, String location, Job job) throws IOException {
    }

    public void storeSchema(ResourceSchema schema, String location, Job job) throws IOException {
    }

    public void setLocation(String location, Job job) throws IOException {
        this.init(location, job, true);
        Configuration cfg = job.getConfiguration();
        Settings settings = HadoopSettingsManager.loadFrom(cfg);
        Properties udfProperties = this.getUDFProperties();
        String delegationTokenSet = udfProperties.getProperty(CREDENTIALS_ADDED);
        if (delegationTokenSet == null) {
            this.addEsApiKeyToken(settings, job);
            udfProperties.setProperty(CREDENTIALS_ADDED, "true");
        }
        if (settings.getScrollFields() == null) {
            this.extractProjection(cfg);
        }
    }

    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        this.relativeLocation = location;
        return this.relativeLocation;
    }

    public InputFormat getInputFormat() throws IOException {
        return new EsPigInputFormat();
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.reader = reader;
        this.aliasesTupleNames = StringUtils.tokenize(this.getUDFProperties().getProperty("es.internal.mr.target.fields"));
    }

    public Tuple getNext() throws IOException {
        try {
            Map<String, Object> dataMap;
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            if (this.isJSON) {
                dataMap = new HashMap(1);
                dataMap.put("data", this.reader.getCurrentValue());
            } else {
                dataMap = (Map)this.reader.getCurrentValue();
            }
            Tuple tuple = TupleFactory.getInstance().newTuple(dataMap.size());
            if (dataMap.isEmpty()) {
                return tuple;
            }
            if (!this.aliasesTupleNames.isEmpty()) {
                for (int i = 0; i < this.aliasesTupleNames.size(); ++i) {
                    Map<String, Object> result = dataMap;
                    for (String level : StringUtils.tokenize(this.aliasesTupleNames.get(i), ".")) {
                        if (!(result instanceof Map) || (result = result.get(level)) != null) continue;
                        break;
                    }
                    tuple.set(i, result);
                }
            } else {
                int i = 0;
                Set entrySet = dataMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    tuple.set(i++, entry.getValue());
                }
            }
            if (this.trace) {
                log.trace((Object)("Reading out tuple " + tuple));
            }
            return tuple;
        }
        catch (InterruptedException ex) {
            throw new IOException("interrupted", ex);
        }
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        String fields = PigUtils.asProjection(requiredFieldList, this.properties);
        this.getUDFProperties().setProperty("es.internal.mr.target.fields", fields);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Given push projection; saving field projection [%s]", fields));
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        return null;
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    public void setUDFContextSignature(String signature) {
        this.signature = signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEsApiKeyToken(Settings esSettings, Job job) {
        if (!UDFContext.getUDFContext().isFrontend()) {
            return;
        }
        UserProvider userProvider = UserProvider.create(esSettings);
        if (userProvider.isEsKerberosEnabled()) {
            User user = userProvider.getUser();
            if (user.getKerberosPrincipal() != null) {
                try (RestClient tokenBootstrap = new RestClient(esSettings);){
                    TokenUtil.obtainTokenForJob(tokenBootstrap, user, job);
                }
            } else {
                log.info((Object)"Not loading Elasticsearch API Key for auth delegation since no Kerberos TGT exist.");
            }
        }
    }

    private void extractProjection(Configuration cfg) throws IOException {
        String fields = this.getUDFProperties().getProperty("es.internal.mr.target.fields");
        if (fields != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found field project [%s] in UDF properties", fields));
            }
            cfg.set("es.internal.mr.target.fields", fields);
            return;
        }
    }
}

