/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.EsMajorVersion;
import org.elasticsearch.hadoop.util.StringUtils;

public class Resource {
    private static final Log LOG = LogFactory.getLog(Resource.class);
    public static final String UNDERSCORE_DOC = "_doc";
    private final String index;
    private final boolean typed;
    private final String type;
    private final String bulk;
    private final String refresh;

    public Resource(Settings settings, boolean read) {
        String res;
        int slash;
        String resource = read ? settings.getResourceRead() : settings.getResourceWrite();
        String errorMessage = "invalid resource given; expecting [index]/[type] - received ";
        Assert.hasText(resource, errorMessage + resource);
        if (resource.contains("?") || resource.contains("&")) {
            if (StringUtils.hasText(settings.getQuery())) {
                throw new EsHadoopIllegalArgumentException(String.format("Cannot specify a query in the target index AND through %s", "es.query"));
            }
            int index = resource.indexOf("?");
            if (index > 0) {
                String query = resource.substring(index);
                resource = (index = (resource = resource.substring(0, index)).lastIndexOf("/")) > 0 ? resource.substring(0, index) : resource;
                settings.setProperty("es.resource", resource);
                settings.setQuery(query);
            }
        }
        boolean typeExists = (slash = (res = StringUtils.sanitizeResource(resource)).indexOf("/")) >= 0;
        EsMajorVersion esMajorVersion = settings.getInternalVersionOrThrow();
        if (esMajorVersion.after(EsMajorVersion.V_7_X) && typeExists) {
            throw new EsHadoopIllegalArgumentException(String.format("Detected type name in resource [%s]. Remove type name to continue.", resource));
        }
        if (esMajorVersion.onOrBefore(EsMajorVersion.V_7_X) && typeExists) {
            LOG.warn((Object)String.format("Detected type name in resource [%s]. Type names are deprecated and will be removed in a later release.", resource));
        }
        if (esMajorVersion.onOrBefore(EsMajorVersion.V_6_X) && !read && !typeExists) {
            throw new EsHadoopIllegalArgumentException(String.format("No type found; Types are required when writing in ES versions 6 and below. Expected [index]/[type], but got [%s]", resource));
        }
        if (typeExists) {
            this.index = res.substring(0, slash);
            this.type = res.substring(slash + 1);
            this.typed = true;
            Assert.hasText(this.type, "No type found; expecting [index]/[type]");
        } else {
            this.index = res;
            this.type = UNDERSCORE_DOC;
            this.typed = false;
        }
        Assert.hasText(this.index, "No index found; expecting [index]/[type]");
        Assert.isTrue(!StringUtils.hasWhitespace(this.index) && !StringUtils.hasWhitespace(this.type), "Index/type should not contain whitespaces");
        String bulkEndpoint = "/_bulk";
        String ingestPipeline = settings.getIngestPipeline();
        if (StringUtils.hasText(ingestPipeline)) {
            Assert.isTrue(!StringUtils.hasWhitespace(ingestPipeline), "Ingest Pipeline name should not contain whitespaces");
            Assert.isTrue(!"update".equals(settings.getOperation()) && !"upsert".equals(settings.getOperation()), "Cannot specify an ingest pipeline when doing updates or upserts");
            bulkEndpoint = bulkEndpoint + "?pipeline=" + ingestPipeline;
        }
        this.bulk = this.index.contains("{") || this.typed && this.type.contains("{") ? bulkEndpoint : (this.typed ? this.index + "/" + this.type + bulkEndpoint : this.index + bulkEndpoint);
        this.refresh = this.index.contains("{") ? "/_refresh" : this.index + "/_refresh";
    }

    String bulk() {
        return this.bulk;
    }

    String mapping() {
        if (this.typed) {
            return this.index + "/_mapping/" + this.type;
        }
        return this.index + "/_mapping";
    }

    String aliases() {
        return this.index + "/_aliases";
    }

    public String index() {
        return this.index;
    }

    public boolean isTyped() {
        return this.typed;
    }

    public String type() {
        return this.type;
    }

    public String toString() {
        if (this.typed) {
            return this.index + "/" + this.type;
        }
        return this.index;
    }

    public String refresh() {
        return this.refresh;
    }
}

