/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cascading;

import cascading.scheme.SinkCall;
import cascading.tuple.Tuple;
import org.elasticsearch.hadoop.cascading.CascadingUtils;
import org.elasticsearch.hadoop.mr.WritableBytesConverter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;

public class CascadingLocalBytesConverter
extends WritableBytesConverter {
    @Override
    public void convert(Object from, BytesArray to) {
        Assert.isTrue(from instanceof SinkCall, String.format("Unexpected object type, expecting [%s], given [%s]", SinkCall.class, from.getClass()));
        SinkCall sinkCall = (SinkCall)from;
        Tuple rawTuple = sinkCall.getOutgoingEntry().getTuple();
        if (rawTuple == null || rawTuple.isEmpty()) {
            to.bytes("{}");
            return;
        }
        Assert.isTrue(rawTuple.size() == 1, "When using JSON input, only one field is expected");
        Tuple tuple = CascadingUtils.coerceToString(sinkCall);
        super.convert(tuple.getObject(0), to);
    }
}

