/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.storm.serialization;

import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.builder.FilteringValueWriter;
import org.elasticsearch.hadoop.serialization.builder.JdkValueWriter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;

public class StormValueWriter
extends FilteringValueWriter<Tuple> {
    private final ValueWriter<Object> jdkWriter;

    public StormValueWriter() {
        this(false);
    }

    public StormValueWriter(boolean writeUnknownTypes) {
        this.jdkWriter = new JdkValueWriter(writeUnknownTypes);
    }

    @Override
    public ValueWriter.Result write(Tuple value, Generator generator) {
        return this.doWrite(value, generator, null);
    }

    protected ValueWriter.Result doWrite(Tuple tuple, Generator generator, String parentField) {
        Fields fields = tuple.getFields();
        generator.writeBeginObject();
        for (String field : fields) {
            ValueWriter.Result result;
            if (!this.shouldKeep(parentField, field)) continue;
            generator.writeFieldName(field);
            Object value = tuple.getValueByField(field);
            if (!(value instanceof Tuple ? !(result = this.write((Tuple)value, generator)).isSuccesful() : !(result = this.jdkWriter.write(value, generator)).isSuccesful())) continue;
            return result;
        }
        generator.writeEndObject();
        return ValueWriter.Result.SUCCESFUL();
    }
}

