/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cfg;

import java.io.InputStream;
import java.util.Properties;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;

public class PropertiesSettings
extends Settings {
    protected final Properties props;

    public PropertiesSettings() {
        this(new Properties());
    }

    public PropertiesSettings(Properties props) {
        Assert.notNull(props, "Non-null properties expected");
        this.props = props;
    }

    @Override
    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.props.setProperty(name, value);
    }

    @Override
    public Settings copy() {
        return new PropertiesSettings((Properties)this.props.clone());
    }

    @Override
    public InputStream loadResource(String location) {
        return IOUtils.open(location, PropertiesSettings.class.getClassLoader());
    }

    @Override
    public Properties asProperties() {
        return this.props;
    }

    public static Settings readFrom(String ser) {
        return new PropertiesSettings(new Properties()).load(ser);
    }
}

