/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.elasticsearch.hadoop.hive.HiveType;
import org.elasticsearch.hadoop.mr.WritableBytesConverter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;

public class HiveBytesConverter
extends WritableBytesConverter {
    @Override
    public void convert(Object from, BytesArray to) {
        Assert.isTrue(from instanceof HiveType, String.format("Unexpected object type, expecting [%s], given [%s]", HiveType.class, from.getClass()));
        HiveType ht = (HiveType)from;
        ObjectInspector oi = ht.getObjectInspector();
        Assert.isTrue(ObjectInspector.Category.STRUCT == oi.getCategory(), String.format("Unexpected object category, expecting [%s], given [%s]", ObjectInspector.Category.STRUCT, oi.getTypeName()));
        StructObjectInspector soi = (StructObjectInspector)oi;
        List refs = soi.getAllStructFieldRefs();
        Assert.isTrue(refs.size() == 1, "When using JSON input, only one field is expected");
        StructField structField = (StructField)refs.get(0);
        ObjectInspector foi = structField.getFieldObjectInspector();
        Assert.isTrue(ObjectInspector.Category.PRIMITIVE == foi.getCategory(), String.format("Unexpected object category, expecting [%s], given [%s]", ObjectInspector.Category.PRIMITIVE, oi.getTypeName()));
        Object writable = ((PrimitiveObjectInspector)foi).getPrimitiveWritableObject(soi.getStructFieldData(ht.getObject(), structField));
        if (writable != null && "org.apache.hadoop.hive.serde2.io.HiveVarcharWritable".equals(writable.getClass().getName())) {
            to.bytes(writable.toString());
            return;
        }
        super.convert(writable, to);
    }
}

