/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.wikipedia.support;

import org.elasticsearch.river.wikipedia.support.PageCallbackHandler;
import org.elasticsearch.river.wikipedia.support.WikiPage;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SAXPageCallbackHandler
extends DefaultHandler {
    private PageCallbackHandler pageHandler;
    private WikiPage currentPage;
    private String currentTag;
    private String currentWikitext;
    private String currentTitle;
    private String currentID;

    public SAXPageCallbackHandler(PageCallbackHandler ph) {
        this.pageHandler = ph;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attr) {
        this.currentTag = qName;
        if (qName.equals("page")) {
            this.currentPage = new WikiPage();
            this.currentWikitext = "";
            this.currentTitle = "";
            this.currentID = "";
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("page")) {
            this.currentPage.setTitle(this.currentTitle);
            this.currentPage.setID(this.currentID);
            this.currentPage.setWikiText(this.currentWikitext);
            this.pageHandler.process(this.currentPage);
        }
        if (qName.equals("mediawiki")) {
            // empty if block
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.currentTag.equals("title")) {
            this.currentTitle = this.currentTitle.concat(new String(ch, start, length));
        } else if (this.currentTag.equals("id") && this.currentID.length() == 0) {
            this.currentID = new String(ch, start, length);
        } else if (this.currentTag.equals("text")) {
            this.currentWikitext = this.currentWikitext.concat(new String(ch, start, length));
        }
    }
}

