/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.wikipedia.support;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.elasticsearch.common.compress.bzip2.CBZip2InputStream;
import org.elasticsearch.river.wikipedia.support.PageCallbackHandler;
import org.elasticsearch.river.wikipedia.support.WikiPage;
import org.elasticsearch.river.wikipedia.support.WikiPageIterator;
import org.xml.sax.InputSource;

public abstract class WikiXMLParser {
    private URL wikiXMLFile = null;
    protected WikiPage currentPage = null;

    public WikiXMLParser(URL fileName) {
        this.wikiXMLFile = fileName;
    }

    public abstract void setPageCallback(PageCallbackHandler var1) throws Exception;

    public abstract void parse() throws Exception;

    public abstract WikiPageIterator getIterator() throws Exception;

    protected InputSource getInputSource() throws Exception {
        BufferedReader br = null;
        if (this.wikiXMLFile.toExternalForm().endsWith(".gz")) {
            br = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(this.wikiXMLFile.openStream()), "UTF-8"));
        } else if (this.wikiXMLFile.toExternalForm().endsWith(".bz2")) {
            InputStream fis = this.wikiXMLFile.openStream();
            byte[] ignoreBytes = new byte[2];
            fis.read(ignoreBytes);
            br = new BufferedReader(new InputStreamReader((InputStream)new CBZip2InputStream(fis), "UTF-8"));
        } else {
            br = new BufferedReader(new InputStreamReader(this.wikiXMLFile.openStream(), "UTF-8"));
        }
        return new InputSource(br);
    }

    protected void notifyPage(WikiPage page) {
        this.currentPage = page;
    }
}

