/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.wikipedia.support;

import java.net.URL;
import org.elasticsearch.river.wikipedia.support.IteratorHandler;
import org.elasticsearch.river.wikipedia.support.PageCallbackHandler;
import org.elasticsearch.river.wikipedia.support.SAXPageCallbackHandler;
import org.elasticsearch.river.wikipedia.support.WikiPageIterator;
import org.elasticsearch.river.wikipedia.support.WikiXMLParser;
import org.elasticsearch.river.wikipedia.support.WikiXMLParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class WikiXMLSAXParser
extends WikiXMLParser {
    private XMLReader xmlReader;
    private PageCallbackHandler pageHandler = null;

    public WikiXMLSAXParser(URL fileName) {
        super(fileName);
        try {
            this.xmlReader = XMLReaderFactory.createXMLReader();
            this.pageHandler = new IteratorHandler(this);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setPageCallback(PageCallbackHandler handler) throws Exception {
        this.pageHandler = handler;
    }

    @Override
    public void parse() throws Exception {
        this.xmlReader.setContentHandler(new SAXPageCallbackHandler(this.pageHandler));
        this.xmlReader.parse(this.getInputSource());
    }

    @Override
    public WikiPageIterator getIterator() throws Exception {
        if (!(this.pageHandler instanceof IteratorHandler)) {
            throw new Exception("Custom page callback found. Will not iterate.");
        }
        throw new UnsupportedOperationException();
    }

    public static void parseWikipediaDump(URL dumpFile, PageCallbackHandler handler) throws Exception {
        WikiXMLParser wxsp = WikiXMLParserFactory.getSAXParser(dumpFile);
        wxsp.setPageCallback(handler);
        wxsp.parse();
    }
}

