/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.wikipedia.support;

import java.util.List;
import org.elasticsearch.river.wikipedia.support.InfoBox;
import org.elasticsearch.river.wikipedia.support.WikiTextParser;

public class WikiPage {
    private String title = null;
    private WikiTextParser wikiTextParser = null;
    private String id = null;

    public void setTitle(String title) {
        this.title = title;
    }

    public void setWikiText(String wtext) {
        this.wikiTextParser = new WikiTextParser(wtext);
    }

    public String getTitle() {
        return this.title;
    }

    public String getTranslatedTitle(String languageCode) {
        return this.wikiTextParser.getTranslatedTitle(languageCode);
    }

    public boolean isDisambiguationPage() {
        return this.title.contains("(disambiguation)") || this.wikiTextParser.isDisambiguationPage();
    }

    public boolean isSpecialPage() {
        return this.title.contains(":");
    }

    public String getWikiText() {
        return this.wikiTextParser.getText();
    }

    public boolean isRedirect() {
        return this.wikiTextParser.isRedirect();
    }

    public boolean isStub() {
        return this.wikiTextParser.isStub();
    }

    public String getRedirectPage() {
        return this.wikiTextParser.getRedirectText();
    }

    public String getText() {
        return this.wikiTextParser.getPlainText();
    }

    public List<String> getCategories() {
        return this.wikiTextParser.getCategories();
    }

    public List<String> getLinks() {
        return this.wikiTextParser.getLinks();
    }

    public void setID(String id) {
        this.id = id;
    }

    public InfoBox getInfoBox() {
        return this.wikiTextParser.getInfoBox();
    }

    public String getID() {
        return this.id;
    }
}

