/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.commonshttp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Locale;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.DelegatingInputStream;
import org.elasticsearch.hadoop.rest.EsHadoopTransportException;
import org.elasticsearch.hadoop.rest.Request;
import org.elasticsearch.hadoop.rest.Response;
import org.elasticsearch.hadoop.rest.ReusableInputStream;
import org.elasticsearch.hadoop.rest.SimpleResponse;
import org.elasticsearch.hadoop.rest.Transport;
import org.elasticsearch.hadoop.rest.commonshttp.BytesArrayRequestEntity;
import org.elasticsearch.hadoop.rest.commonshttp.DelegatedProtocol;
import org.elasticsearch.hadoop.rest.commonshttp.DeleteMethodWithBody;
import org.elasticsearch.hadoop.rest.commonshttp.GetMethodWithBody;
import org.elasticsearch.hadoop.rest.commonshttp.SSLSocketFactory;
import org.elasticsearch.hadoop.rest.commonshttp.SocksSocketFactory;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.util.ByteSequence;
import org.elasticsearch.hadoop.util.ReflectionUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class CommonsHttpTransport
implements Transport,
StatsAware {
    private static Log log = LogFactory.getLog(CommonsHttpTransport.class);
    private static final Method GET_SOCKET = ReflectionUtils.findMethod(HttpConnection.class, "getSocket", null);
    private final HttpClient client;
    private final Stats stats = new Stats();
    private HttpConnection conn;
    private String proxyInfo = "";
    private final String httpInfo;
    private final boolean sslEnabled;
    private final String pathPrefix;
    private final Settings settings;

    public CommonsHttpTransport(Settings settings, String host) {
        this.settings = settings;
        this.httpInfo = host;
        this.sslEnabled = settings.getNetworkSSLEnabled();
        String pathPref = settings.getNodesPathPrefix();
        this.pathPrefix = StringUtils.hasText(pathPref) ? CommonsHttpTransport.addLeadingSlashIfNeeded(StringUtils.trimWhitespace(pathPref)) : StringUtils.trimWhitespace(pathPref);
        HttpClientParams params = new HttpClientParams();
        params.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(settings.getHttpRetries(), false){

            public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                if (super.retryMethod(method, exception, executionCount)) {
                    ++((CommonsHttpTransport)CommonsHttpTransport.this).stats.netRetries;
                    return true;
                }
                return false;
            }
        });
        params.setConnectionManagerTimeout(settings.getHttpTimeout());
        params.setSoTimeout((int)settings.getHttpTimeout());
        params.setCredentialCharset(StringUtils.UTF_8.name());
        params.setContentCharset(StringUtils.UTF_8.name());
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig = this.setupSSLIfNeeded(settings, hostConfig);
        hostConfig = this.setupSocksProxy(settings, hostConfig);
        Object[] authSettings = this.setupHttpOrHttpsProxy(settings, hostConfig);
        hostConfig = (HostConfiguration)authSettings[0];
        try {
            hostConfig.setHost(new URI(CommonsHttpTransport.escapeUri(host, this.sslEnabled), false));
        }
        catch (IOException ex) {
            throw new EsHadoopTransportException("Invalid target URI " + host, ex);
        }
        this.client = new HttpClient(params, (HttpConnectionManager)new SocketTrackingConnectionManager());
        this.client.setHostConfiguration(hostConfig);
        this.addHttpAuth(settings, authSettings);
        this.completeAuth(authSettings);
        HttpConnectionManagerParams connectionParams = this.client.getHttpConnectionManager().getParams();
        connectionParams.setTcpNoDelay(true);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Opening HTTP transport to " + this.httpInfo));
        }
    }

    private HostConfiguration setupSSLIfNeeded(Settings settings, HostConfiguration hostConfig) {
        if (!this.sslEnabled) {
            return hostConfig;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"SSL Connection enabled");
        }
        String schema = "https";
        int port = 443;
        SSLSocketFactory sslFactory = new SSLSocketFactory(settings);
        CommonsHttpTransport.replaceProtocol((ProtocolSocketFactory)sslFactory, schema, port);
        return hostConfig;
    }

    private void addHttpAuth(Settings settings, Object[] authSettings) {
        if (StringUtils.hasText(settings.getNetworkHttpAuthUser())) {
            HttpState state = authSettings[1] != null ? (HttpState)authSettings[1] : new HttpState();
            authSettings[1] = state;
            state.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(settings.getNetworkHttpAuthUser(), settings.getNetworkHttpAuthPass()));
            if (log.isDebugEnabled()) {
                log.info((Object)"Using detected HTTP Auth credentials...");
            }
        }
    }

    private void completeAuth(Object[] authSettings) {
        if (authSettings[1] != null) {
            this.client.setState((HttpState)authSettings[1]);
            this.client.getParams().setAuthenticationPreemptive(true);
        }
    }

    private Object[] setupHttpOrHttpsProxy(Settings settings, HostConfiguration hostConfig) {
        Object[] results = new Object[2];
        results[0] = hostConfig;
        String proxyHost = null;
        int proxyPort = -1;
        if (this.sslEnabled) {
            if (settings.getNetworkHttpsUseSystemProperties()) {
                proxyHost = System.getProperty("https.proxyHost");
                proxyPort = Integer.getInteger("https.proxyPort", -1);
            }
            if (StringUtils.hasText(settings.getNetworkProxyHttpsHost())) {
                proxyHost = settings.getNetworkProxyHttpsHost();
            }
            if (settings.getNetworkProxyHttpsPort() > 0) {
                proxyPort = settings.getNetworkProxyHttpsPort();
            }
        } else {
            if (settings.getNetworkHttpUseSystemProperties()) {
                proxyHost = System.getProperty("http.proxyHost");
                proxyPort = Integer.getInteger("http.proxyPort", -1);
            }
            if (StringUtils.hasText(settings.getNetworkProxyHttpHost())) {
                proxyHost = settings.getNetworkProxyHttpHost();
            }
            if (settings.getNetworkProxyHttpPort() > 0) {
                proxyPort = settings.getNetworkProxyHttpPort();
            }
        }
        if (StringUtils.hasText(proxyHost)) {
            hostConfig.setProxy(proxyHost, proxyPort);
            this.proxyInfo = this.proxyInfo.concat(String.format(Locale.ROOT, "[%s proxy %s:%s]", this.sslEnabled ? "HTTPS" : "HTTP", proxyHost, proxyPort));
            if (this.sslEnabled) {
                if (StringUtils.hasText(settings.getNetworkProxyHttpsUser())) {
                    if (!StringUtils.hasText(settings.getNetworkProxyHttpsPass())) {
                        log.warn((Object)String.format("HTTPS proxy user specified but no/empty password defined - double check the [%s] property", "es.net.proxy.https.pass"));
                    }
                    HttpState state = new HttpState();
                    state.setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(settings.getNetworkProxyHttpsUser(), settings.getNetworkProxyHttpsPass()));
                    results[1] = state;
                }
                if (log.isDebugEnabled()) {
                    if (StringUtils.hasText(settings.getNetworkProxyHttpsUser())) {
                        log.debug((Object)String.format("Using authenticated HTTPS proxy [%s:%s]", proxyHost, proxyPort));
                    } else {
                        log.debug((Object)String.format("Using HTTPS proxy [%s:%s]", proxyHost, proxyPort));
                    }
                }
            } else {
                if (StringUtils.hasText(settings.getNetworkProxyHttpUser())) {
                    if (!StringUtils.hasText(settings.getNetworkProxyHttpPass())) {
                        log.warn((Object)String.format("HTTP proxy user specified but no/empty password defined - double check the [%s] property", "es.net.proxy.http.pass"));
                    }
                    HttpState state = new HttpState();
                    state.setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(settings.getNetworkProxyHttpUser(), settings.getNetworkProxyHttpPass()));
                    results[1] = state;
                }
                if (log.isDebugEnabled()) {
                    if (StringUtils.hasText(settings.getNetworkProxyHttpUser())) {
                        log.debug((Object)String.format("Using authenticated HTTP proxy [%s:%s]", proxyHost, proxyPort));
                    } else {
                        log.debug((Object)String.format("Using HTTP proxy [%s:%s]", proxyHost, proxyPort));
                    }
                }
            }
        }
        return results;
    }

    private HostConfiguration setupSocksProxy(Settings settings, HostConfiguration hostConfig) {
        String proxyHost = null;
        int proxyPort = -1;
        String proxyUser = null;
        String proxyPass = null;
        if (settings.getNetworkHttpUseSystemProperties()) {
            proxyHost = System.getProperty("socksProxyHost");
            proxyPort = Integer.getInteger("socksProxyPort", -1);
            proxyUser = System.getProperty("java.net.socks.username");
            proxyPass = System.getProperty("java.net.socks.password");
        }
        if (StringUtils.hasText(settings.getNetworkProxySocksHost())) {
            proxyHost = settings.getNetworkProxySocksHost();
        }
        if (settings.getNetworkProxySocksPort() > 0) {
            proxyPort = settings.getNetworkProxySocksPort();
        }
        if (StringUtils.hasText(settings.getNetworkProxySocksUser())) {
            proxyUser = settings.getNetworkProxySocksUser();
        }
        if (StringUtils.hasText(settings.getNetworkProxySocksPass())) {
            proxyPass = settings.getNetworkProxySocksPass();
        }
        if (StringUtils.hasText(proxyHost)) {
            this.proxyInfo = this.proxyInfo.concat(String.format("[SOCKS proxy %s:%s]", proxyHost, proxyPort));
            if (!StringUtils.hasText(proxyUser)) {
                log.warn((Object)String.format("SOCKS proxy user specified but no/empty password defined - double check the [%s] property", "es.net.proxy.socks.pass"));
            }
            if (log.isDebugEnabled()) {
                if (StringUtils.hasText(proxyUser)) {
                    log.debug((Object)String.format("Using authenticated SOCKS proxy [%s:%s]", proxyHost, proxyPort));
                } else {
                    log.debug((Object)String.format("Using SOCKS proxy [%s:%s]", proxyHost, proxyPort));
                }
            }
            String schema = this.sslEnabled ? "https" : "http";
            int port = this.sslEnabled ? 443 : 80;
            SocksSocketFactory socketFactory = new SocksSocketFactory(proxyHost, proxyPort, proxyUser, proxyPass);
            CommonsHttpTransport.replaceProtocol((ProtocolSocketFactory)socketFactory, schema, port);
        }
        return hostConfig;
    }

    static void replaceProtocol(ProtocolSocketFactory socketFactory, String schema, int defaultPort) {
        Protocol directHttp = Protocol.getProtocol((String)schema);
        if (directHttp instanceof DelegatedProtocol) {
            directHttp = ((DelegatedProtocol)directHttp).getOriginal();
            assert (!(directHttp instanceof DelegatedProtocol));
        }
        DelegatedProtocol proxiedHttp = new DelegatedProtocol(socketFactory, directHttp, schema, defaultPort);
        Protocol.registerProtocol((String)schema, (Protocol)proxiedHttp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute(Request request) throws IOException {
        ByteSequence ba;
        DeleteMethodWithBody http = null;
        switch (request.method()) {
            case DELETE: {
                http = new DeleteMethodWithBody();
                break;
            }
            case HEAD: {
                http = new HeadMethod();
                break;
            }
            case GET: {
                http = request.body() == null ? new GetMethod() : new GetMethodWithBody();
                break;
            }
            case POST: {
                http = new PostMethod();
                break;
            }
            case PUT: {
                http = new PutMethod();
                break;
            }
            default: {
                throw new EsHadoopTransportException("Unknown request method " + (Object)((Object)request.method()));
            }
        }
        CharSequence uri = request.uri();
        if (StringUtils.hasText(uri)) {
            http.setURI(new URI(CommonsHttpTransport.escapeUri(uri.toString(), this.sslEnabled), false));
        }
        http.setPath(this.pathPrefix + CommonsHttpTransport.addLeadingSlashIfNeeded(request.path().toString()));
        try {
            uri = http.getURI().toString();
        }
        catch (URIException uriex) {
            throw new EsHadoopTransportException("Invalid target URI " + request, uriex);
        }
        CharSequence params = request.params();
        if (StringUtils.hasText(params)) {
            http.setQueryString(params.toString());
        }
        if ((ba = request.body()) != null && ba.length() > 0) {
            if (!(http instanceof EntityEnclosingMethod)) {
                throw new IllegalStateException(String.format("Method %s cannot contain body - implementation bug", request.method().name()));
            }
            EntityEnclosingMethod entityMethod = http;
            entityMethod.setRequestEntity((RequestEntity)new BytesArrayRequestEntity(ba));
            entityMethod.setContentChunked(false);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Tx %s[%s]@[%s][%s] w/ payload [%s]", this.proxyInfo, request.method().name(), this.httpInfo, request.path(), request.body()));
        }
        long start = System.currentTimeMillis();
        try {
            this.client.executeMethod((HttpMethod)http);
        }
        finally {
            this.stats.netTotalTime += System.currentTimeMillis() - start;
        }
        if (log.isTraceEnabled()) {
            Socket sk = (Socket)ReflectionUtils.invoke(GET_SOCKET, this.conn, null);
            String addr = sk.getLocalAddress().getHostAddress();
            log.trace((Object)String.format("Rx %s@[%s] [%s-%s] [%s]", this.proxyInfo, addr, http.getStatusCode(), HttpStatus.getStatusText((int)http.getStatusCode()), http.getResponseBodyAsString()));
        }
        return new SimpleResponse(http.getStatusCode(), new ResponseInputStream((HttpMethod)http), this.httpInfo);
    }

    @Override
    public void close() {
        HttpConnectionManager manager;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Closing HTTP transport to " + this.httpInfo));
        }
        if ((manager = this.client.getHttpConnectionManager()) instanceof SocketTrackingConnectionManager) {
            try {
                ((SocketTrackingConnectionManager)manager).close();
            }
            catch (NullPointerException npe) {
            }
            catch (Exception ex) {
                log.warn((Object)"Exception closing underlying HTTP manager", (Throwable)ex);
            }
        }
    }

    private static String escapeUri(String uri, boolean ssl) {
        String escaped = StringUtils.encodeUri(uri);
        return escaped.contains("://") ? escaped : (ssl ? "https://" : "http://") + escaped;
    }

    private static String addLeadingSlashIfNeeded(String string) {
        return string.startsWith("/") ? string : "/" + string;
    }

    @Override
    public Stats stats() {
        return this.stats;
    }

    static {
        ReflectionUtils.makeAccessible(GET_SOCKET);
    }

    private class SocketTrackingConnectionManager
    extends SimpleHttpConnectionManager {
        private SocketTrackingConnectionManager() {
        }

        public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long timeout) {
            CommonsHttpTransport.this.conn = super.getConnectionWithTimeout(hostConfiguration, timeout);
            return CommonsHttpTransport.this.conn;
        }

        public void close() {
            if (this.httpConnection != null) {
                if (this.httpConnection.isOpen()) {
                    this.releaseConnection(this.httpConnection);
                }
                this.httpConnection.close();
            }
            this.httpConnection = null;
            CommonsHttpTransport.this.conn = null;
        }
    }

    private static class ResponseInputStream
    extends DelegatingInputStream
    implements ReusableInputStream {
        private final HttpMethod method;
        private final boolean reusable;

        public ResponseInputStream(HttpMethod http) throws IOException {
            super(http.getResponseBodyAsStream());
            this.method = http;
            this.reusable = this.delegate() instanceof ByteArrayInputStream;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public InputStream copy() {
            try {
                return this.reusable ? this.method.getResponseBodyAsStream() : null;
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalStateException(ex);
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.isNull()) {
                try {
                    super.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.method.releaseConnection();
        }
    }
}

