/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.lang.reflect.Field;
import java.util.Collections;

public abstract class Constants {
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final boolean JRE_IS_MINIMUM_JAVA7;
    public static final boolean JRE_IS_MINIMUM_JAVA8;
    public static final boolean JRE_IS_64BIT;

    static {
        boolean is64Bit = false;
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Object unsafe = unsafeField.get(null);
            int addressSize = ((Number)unsafeClass.getMethod("addressSize", new Class[0]).invoke(unsafe, new Object[0])).intValue();
            is64Bit = addressSize >= 8;
        }
        catch (Exception e) {
            String x = System.getProperty("sun.arch.data.model");
            is64Bit = x != null ? x.indexOf("64") != -1 : OS_ARCH != null && OS_ARCH.indexOf("64") != -1;
        }
        JRE_IS_64BIT = is64Bit;
        boolean v7 = true;
        try {
            Throwable.class.getMethod("getSuppressed", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            v7 = false;
        }
        JRE_IS_MINIMUM_JAVA7 = v7;
        if (JRE_IS_MINIMUM_JAVA7) {
            boolean v8 = true;
            try {
                Collections.class.getMethod("emptySortedSet", new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                v8 = false;
            }
            JRE_IS_MINIMUM_JAVA8 = v8;
        } else {
            JRE_IS_MINIMUM_JAVA8 = false;
        }
    }
}

