/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql;

import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SchemaRDD;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.spark.cfg.SparkSettings;
import org.elasticsearch.spark.cfg.SparkSettingsManager;
import org.elasticsearch.spark.sql.EsSchemaRDDWriter;
import org.elasticsearch.spark.sql.ScalaEsRowRDD;
import org.elasticsearch.spark.sql.SchemaUtils;
import org.elasticsearch.spark.sql.SchemaUtils$;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.generic.Growable;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;

public final class EsSparkSQL$ {
    public static final EsSparkSQL$ MODULE$;

    static {
        new EsSparkSQL$();
    }

    public SchemaRDD esRDD(SQLContext sc) {
        return this.esRDD(sc, (Map<String, String>)Map$.MODULE$.empty());
    }

    public SchemaRDD esRDD(SQLContext sc, String resource) {
        return this.esRDD(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource)}))));
    }

    public SchemaRDD esRDD(SQLContext sc, String resource, String query) {
        return this.esRDD(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.query"), (Object)query)}))));
    }

    public SchemaRDD esRDD(SQLContext sc, Map<String, String> cfg) {
        Settings esConf = new SparkSettingsManager().load(sc.sparkContext().getConf()).copy();
        esConf.merge((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(cfg).asJava());
        SchemaUtils.Schema schema = SchemaUtils$.MODULE$.discoverMapping(esConf);
        ScalaEsRowRDD rowRDD = new ScalaEsRowRDD(sc.sparkContext(), (Map<String, String>)((Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(esConf.asProperties()).asScala()), schema);
        return sc.applySchema((RDD)rowRDD, schema.struct());
    }

    public SchemaRDD esRDD(SQLContext sc, String resource, String query, Map<String, String> cfg) {
        return this.esRDD(sc, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.query"), (Object)query), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
    }

    public SchemaRDD esRDD(SQLContext sc, String resource, Map<String, String> cfg) {
        return this.esRDD(sc, (Map<String, String>)((Map)((MapLike)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource))));
    }

    public void saveToEs(SchemaRDD srdd, String resource) {
        this.saveToEs(srdd, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.write"), (Object)resource)}))));
    }

    public void saveToEs(SchemaRDD srdd, String resource, Map<String, String> cfg) {
        this.saveToEs(srdd, (Map<String, String>)((Map)((MapLike)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.write"), (Object)resource))));
    }

    public void saveToEs(SchemaRDD srdd, Map<String, String> cfg) {
        if (srdd == null || srdd.partitions().length == 0) {
            return;
        }
        SparkContext sparkCtx = srdd.sparkContext();
        SparkSettings sparkCfg = new SparkSettingsManager().load(sparkCtx.getConf());
        Settings esCfg = new PropertiesSettings().load(sparkCfg.save());
        esCfg.merge((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(cfg).asJava());
        InitializationUtils.checkIdForOperation(esCfg);
        InitializationUtils.checkIndexExistence(esCfg, null);
        EsSchemaRDDWriter esSchemaRDDWriter = new EsSchemaRDDWriter(srdd.schema(), esCfg.save());
        sparkCtx.runJob((RDD)srdd, (Function2)new Serializable(esSchemaRDDWriter){
            public static final long serialVersionUID = 0L;
            private final EsSchemaRDDWriter eta$0$1$1;

            public final void apply(TaskContext taskContext, Iterator<Row> data) {
                this.eta$0$1$1.write(taskContext, data);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, ClassTag$.MODULE$.Unit());
    }

    private EsSparkSQL$() {
        MODULE$ = this;
    }
}

