/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.sql.catalyst.types.ArrayType;
import org.apache.spark.sql.catalyst.types.BinaryType$;
import org.apache.spark.sql.catalyst.types.BooleanType$;
import org.apache.spark.sql.catalyst.types.ByteType$;
import org.apache.spark.sql.catalyst.types.DataType;
import org.apache.spark.sql.catalyst.types.DoubleType$;
import org.apache.spark.sql.catalyst.types.FloatType$;
import org.apache.spark.sql.catalyst.types.IntegerType$;
import org.apache.spark.sql.catalyst.types.LongType$;
import org.apache.spark.sql.catalyst.types.MapType;
import org.apache.spark.sql.catalyst.types.NullType$;
import org.apache.spark.sql.catalyst.types.ShortType$;
import org.apache.spark.sql.catalyst.types.StringType$;
import org.apache.spark.sql.catalyst.types.StructField;
import org.apache.spark.sql.catalyst.types.StructField$;
import org.apache.spark.sql.catalyst.types.StructType;
import org.apache.spark.sql.catalyst.types.TimestampType$;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoField;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingUtils;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.spark.sql.SchemaUtils;
import org.elasticsearch.spark.sql.Utils;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.ArraySeq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class SchemaUtils$ {
    public static final SchemaUtils$ MODULE$;
    private final String readInclude;
    private final String readExclude;

    static {
        new SchemaUtils$();
    }

    public String readInclude() {
        return this.readInclude;
    }

    public String readExclude() {
        return this.readExclude;
    }

    public SchemaUtils.Schema discoverMapping(Settings cfg) {
        Field field = this.discoverMappingAsField(cfg);
        StructType struct = this.convertToStruct(field, cfg);
        return new SchemaUtils.Schema(field, struct);
    }

    public Field discoverMappingAsField(Settings cfg) {
        RestRepository repo = new RestRepository(cfg);
        try {
            if (repo.indexExists(true)) {
                Field field = repo.getMapping();
                if (field == null) {
                    throw new EsHadoopIllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find mapping for ", " - one is required before using Spark SQL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cfg.getResourceRead()})));
                }
                Map<String, GeoField> geoInfo = repo.sampleGeoFields(field = MappingUtils.filterMapping(field, cfg));
                if (geoInfo.isEmpty()) {
                    if (StringUtils.hasText(cfg.getReadFieldInclude()) || StringUtils.hasText(cfg.getReadFieldExclude())) {
                        cfg.setProperty("es.internal.mr.target.fields", StringUtils.concatenate(Field.toLookupMap(field).keySet(), ","));
                    }
                    return field;
                }
                throw new EsHadoopIllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geo types are supported only in ES-Hadoop for SparkSQL 1.3 (or higher) DataFrames"})).s((Seq)Nil$.MODULE$));
            }
            throw new EsHadoopIllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find mapping for ", " - one is required before using Spark SQL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cfg.getResourceRead()})));
        }
        finally {
            repo.close();
        }
    }

    private StructType convertToStruct(Field rootField, Settings cfg) {
        List<FieldFilter.NumberedInclude> arrayIncludes = SettingsUtils.getFieldArrayFilterInclude(cfg);
        List<String> arrayExcludes = StringUtils.tokenize(cfg.getReadFieldAsArrayExclude());
        ArraySeq fields = (ArraySeq)Predef$.MODULE$.refArrayOps((Object[])rootField.properties()).map((Function1)new Serializable(arrayIncludes, arrayExcludes){
            public static final long serialVersionUID = 0L;
            private final List arrayIncludes$2;
            private final List arrayExcludes$2;

            public final StructField apply(Field fl) {
                return SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$convertField(fl, null, this.arrayIncludes$2, this.arrayExcludes$2);
            }
            {
                this.arrayIncludes$2 = arrayIncludes$2;
                this.arrayExcludes$2 = arrayExcludes$2;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        if (cfg.getReadMetadata()) {
            StructField metadataMap = new StructField(cfg.getReadMetadataField(), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.$lessinit$greater$default$4());
            fields = (ArraySeq)fields.$colon$plus((Object)metadataMap, ArraySeq$.MODULE$.canBuildFrom());
        }
        return new StructType((Seq)fields);
    }

    private StructType convertToStruct(Field field, String parentName, List<FieldFilter.NumberedInclude> arrayIncludes, List<String> arrayExcludes) {
        return new StructType((Seq)Predef$.MODULE$.refArrayOps((Object[])field.properties()).map((Function1)new Serializable(parentName, arrayIncludes, arrayExcludes){
            public static final long serialVersionUID = 0L;
            private final String parentName$1;
            private final List arrayIncludes$1;
            private final List arrayExcludes$1;

            public final StructField apply(Field fl) {
                return SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$convertField(fl, this.parentName$1, this.arrayIncludes$1, this.arrayExcludes$1);
            }
            {
                this.parentName$1 = parentName$1;
                this.arrayIncludes$1 = arrayIncludes$1;
                this.arrayExcludes$1 = arrayExcludes$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
    }

    public StructField org$elasticsearch$spark$sql$SchemaUtils$$convertField(Field field, String parentName, List<FieldFilter.NumberedInclude> arrayIncludes, List<String> arrayExcludes) {
        String absoluteName = parentName == null ? field.name() : new StringBuilder().append((Object)parentName).append((Object)".").append((Object)field.name()).toString();
        FieldFilter.Result matched = FieldFilter.filter(absoluteName, arrayIncludes, arrayExcludes, false);
        boolean createArray = !arrayIncludes.isEmpty() && matched.matched;
        FieldType fieldType = Utils.extractType(field);
        Object object = ((Object)((Object)FieldType.NULL)).equals((Object)fieldType) ? NullType$.MODULE$ : (((Object)((Object)FieldType.BINARY)).equals((Object)fieldType) ? BinaryType$.MODULE$ : (((Object)((Object)FieldType.BOOLEAN)).equals((Object)fieldType) ? BooleanType$.MODULE$ : (((Object)((Object)FieldType.BYTE)).equals((Object)fieldType) ? ByteType$.MODULE$ : (((Object)((Object)FieldType.SHORT)).equals((Object)fieldType) ? ShortType$.MODULE$ : (((Object)((Object)FieldType.INTEGER)).equals((Object)fieldType) ? IntegerType$.MODULE$ : (((Object)((Object)FieldType.LONG)).equals((Object)fieldType) ? LongType$.MODULE$ : (((Object)((Object)FieldType.FLOAT)).equals((Object)fieldType) ? FloatType$.MODULE$ : (((Object)((Object)FieldType.DOUBLE)).equals((Object)fieldType) ? DoubleType$.MODULE$ : (((Object)((Object)FieldType.STRING)).equals((Object)fieldType) ? StringType$.MODULE$ : (((Object)((Object)FieldType.DATE)).equals((Object)fieldType) ? TimestampType$.MODULE$ : (((Object)((Object)FieldType.OBJECT)).equals((Object)fieldType) ? this.convertToStruct(field, absoluteName, arrayIncludes, arrayExcludes) : (((Object)((Object)FieldType.NESTED)).equals((Object)fieldType) ? new ArrayType((DataType)this.convertToStruct(field, absoluteName, arrayIncludes, arrayExcludes), true) : StringType$.MODULE$))))))))))));
        ObjectRef dataType = ObjectRef.create((Object)object);
        if (createArray) {
            boolean currentDepth = false;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), matched.depth).foreach$mVc$sp((Function1)new Serializable(dataType){
                public static final long serialVersionUID = 0L;
                private final ObjectRef dataType$1;

                public final void apply(int currentDepth) {
                    this.apply$mcVI$sp(currentDepth);
                }

                public void apply$mcVI$sp(int currentDepth) {
                    this.dataType$1.elem = new ArrayType((DataType)this.dataType$1.elem, true);
                }
                {
                    this.dataType$1 = dataType$1;
                }
            });
        }
        return new StructField(field.name(), (DataType)dataType.elem, true, StructField$.MODULE$.$lessinit$greater$default$4());
    }

    public void setRowInfo(Settings settings, StructType struct) {
        Tuple2<Properties, Properties> rowInfo = this.detectRowInfo(settings, struct);
        settings.setProperty(Utils.ROW_INFO_ORDER_PROPERTY, IOUtils.propsToString((Properties)rowInfo._1()));
        settings.setProperty(Utils.ROW_INFO_ARRAY_PROPERTY, IOUtils.propsToString((Properties)rowInfo._2()));
    }

    public Tuple2<LinkedHashMap<String, Seq<String>>, LinkedHashSet<String>> getRowInfo(Settings settings) {
        String rowOrderString = settings.getProperty(Utils.ROW_INFO_ORDER_PROPERTY);
        Assert.hasText(rowOrderString, "no schema/row order detected...");
        Properties rowOrderProps = IOUtils.propsFromString(rowOrderString);
        String rowArrayString = settings.getProperty(Utils.ROW_INFO_ARRAY_PROPERTY);
        Properties rowArrayProps = StringUtils.hasText(rowArrayString) ? IOUtils.propsFromString(rowArrayString) : new Properties();
        LinkedHashMap order = new LinkedHashMap();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(rowOrderProps).asScala()).foreach((Function1)new Serializable(order){
            public static final long serialVersionUID = 0L;
            private final LinkedHashMap order$1;

            public final Object apply(Tuple2<String, String> prop) {
                Buffer value = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(StringUtils.tokenize((String)prop._2())).asScala();
                return value.isEmpty() ? BoxedUnit.UNIT : this.order$1.put(prop._1(), (Object)new ArrayBuffer().$plus$plus$eq((TraversableOnce)value));
            }
            {
                this.order$1 = order$1;
            }
        });
        LinkedHashSet needToBeArray = new LinkedHashSet();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(rowArrayProps).asScala()).foreach((Function1)new Serializable(needToBeArray){
            public static final long serialVersionUID = 0L;
            private final LinkedHashSet needToBeArray$1;

            public final boolean apply(Tuple2<String, String> prop) {
                return this.needToBeArray$1.add(prop._1());
            }
            {
                this.needToBeArray$1 = needToBeArray$1;
            }
        });
        return new Tuple2((Object)order, needToBeArray);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Properties, Properties> detectRowInfo(Settings settings, StructType struct) {
        void var3_3;
        Tuple2 rowInfo = new Tuple2((Object)new Properties(), (Object)new Properties());
        this.org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo((Tuple2<Properties, Properties>)rowInfo, Utils.ROOT_LEVEL_NAME, (DataType)struct);
        String csv = settings.getScrollFields();
        Object object = StringUtils.hasText(csv) ? (settings.getReadMetadata() ? ((Properties)rowInfo._1()).setProperty(Utils.ROOT_LEVEL_NAME, new StringBuilder().append((Object)csv).append((Object)",").append((Object)settings.getReadMetadataField()).toString()) : ((Properties)rowInfo._1()).setProperty(Utils.ROOT_LEVEL_NAME, csv)) : BoxedUnit.UNIT;
        return var3_3;
    }

    public void org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo(Tuple2<Properties, Properties> info, String level, DataType dataType) {
        block3: {
            while (true) {
                DataType dataType2;
                if ((dataType2 = dataType) instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    ArrayList fields = new ArrayList();
                    structType.fields().foreach((Function1)new Serializable(info, level, fields){
                        public static final long serialVersionUID = 0L;
                        private final Tuple2 info$1;
                        private final String level$1;
                        private final ArrayList fields$1;

                        public final void apply(StructField field) {
                            this.fields$1.add(field.name());
                            String string = this.level$1;
                            String string2 = Utils.ROOT_LEVEL_NAME;
                            SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo((Tuple2<Properties, Properties>)this.info$1, !(string != null ? !string.equals(string2) : string2 != null) ? field.name() : new StringBuilder().append((Object)this.level$1).append((Object)".").append((Object)field.name()).toString(), field.dataType());
                        }
                        {
                            this.info$1 = info$1;
                            this.level$1 = level$1;
                            this.fields$1 = fields$1;
                        }
                    });
                    ((Properties)info._1()).setProperty(level, StringUtils.concatenate(fields, ","));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(dataType2 instanceof ArrayType)) break;
                ArrayType arrayType = (ArrayType)dataType2;
                String prop = ((Properties)info._2()).getProperty(level);
                int depth = 0;
                if (StringUtils.hasText(prop)) {
                    depth = Integer.parseInt(prop);
                }
                ((Properties)info._2()).setProperty(level, String.valueOf(++depth));
                dataType = arrayType.elementType();
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private SchemaUtils$() {
        MODULE$ = this;
        this.readInclude = "es.read.field.include";
        this.readExclude = "es.read.field.exclude";
    }
}

