/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util.ecs;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.hadoop.util.ecs.HostData;
import org.elasticsearch.hadoop.util.ecs.MessageTemplate;

public class ElasticCommonSchema {
    public static final String V0_992 = "0.992";
    private final String version;

    public ElasticCommonSchema() {
        this(V0_992);
    }

    public ElasticCommonSchema(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public TemplateBuilder buildTemplate() {
        return new TemplateBuilder(this);
    }

    public static final class TemplateBuilder {
        private ElasticCommonSchema schema;
        private Map<String, String> labels;
        private Set<String> tags;
        private HostData host;
        private String eventCategory;
        private String eventType;

        private TemplateBuilder(ElasticCommonSchema schema2) {
            this.schema = schema2;
            this.labels = new LinkedHashMap<String, String>();
            this.tags = new LinkedHashSet<String>();
            this.host = null;
            this.eventCategory = null;
            this.eventType = null;
        }

        public TemplateBuilder addLabel(String label, String value) {
            this.labels.put(label, value);
            return this;
        }

        public TemplateBuilder addLabels(Map<String, String> labels) {
            this.labels.putAll(labels);
            return this;
        }

        public TemplateBuilder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public TemplateBuilder addTags(Iterable<String> tags) {
            for (String tag : tags) {
                this.addTag(tag);
            }
            return this;
        }

        public TemplateBuilder setEventCategory(String eventCategory) {
            this.eventCategory = eventCategory;
            return this;
        }

        public TemplateBuilder setEventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public MessageTemplate build() {
            if (this.host == null) {
                this.host = HostData.getInstance();
            }
            return new MessageTemplate(this.schema, this.labels, this.tags, this.host, this.eventCategory, this.eventType);
        }
    }
}

